/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.ParameterRewriter;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Property;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public final class PropertyUtil {
    private PropertyUtil() {
    }

    public static Map<String, Optional<Object>> evaluateProperties(Iterable<Property> setProperties, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters, boolean includeAllProperties, Map<String, PropertyMetadata<?>> metadata, ErrorCodeSupplier errorCode, String propertyTypeDescription) {
        LinkedHashMap<String, Optional<Object>> propertyValues = new LinkedHashMap<String, Optional<Object>>();
        for (Property property : setProperties) {
            String propertyName = property.getName().getValue().toLowerCase(Locale.ENGLISH);
            PropertyMetadata<?> propertyMetadata = metadata.get(propertyName);
            if (propertyMetadata == null) {
                throw new TrinoException(errorCode, String.format("%s '%s' does not exist", PropertyUtil.capitalize(propertyTypeDescription), propertyName));
            }
            Optional<Object> value = property.isSetToDefault() ? Optional.ofNullable(propertyMetadata.getDefaultValue()) : Optional.of(PropertyUtil.evaluateProperty(property.getNonDefaultValue(), propertyMetadata, session, plannerContext, accessControl, parameters, errorCode, propertyTypeDescription));
            propertyValues.put(propertyMetadata.getName(), value);
        }
        if (includeAllProperties) {
            for (PropertyMetadata propertyMetadata : metadata.values()) {
                if (propertyValues.containsKey(propertyMetadata.getName())) continue;
                propertyValues.put(propertyMetadata.getName(), Optional.ofNullable(propertyMetadata.getDefaultValue()));
            }
        }
        return ImmutableMap.copyOf(propertyValues);
    }

    private static Object evaluateProperty(Expression expression, PropertyMetadata<?> property, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters, ErrorCodeSupplier errorCode, String propertyTypeDescription) {
        Object sqlObjectValue;
        try {
            Type expectedType = property.getSqlType();
            Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(parameters), (Expression)expression);
            Object value = ExpressionInterpreter.evaluateConstantExpression(rewritten, expectedType, plannerContext, session, accessControl, parameters);
            BlockBuilder blockBuilder = expectedType.createBlockBuilder(null, 1);
            TypeUtils.writeNativeValue((Type)expectedType, (BlockBuilder)blockBuilder, (Object)value);
            sqlObjectValue = expectedType.getObjectValue(session.toConnectorSession(), (Block)blockBuilder, 0);
        }
        catch (TrinoException e) {
            throw new TrinoException(errorCode, String.format("Invalid value for %s '%s': Cannot convert [%s] to %s", propertyTypeDescription, property.getName(), expression, property.getSqlType()), (Throwable)e);
        }
        if (sqlObjectValue == null) {
            throw new TrinoException(errorCode, String.format("Invalid null value for %s '%s' from [%s]", propertyTypeDescription, property.getName(), expression));
        }
        try {
            return property.decode(sqlObjectValue);
        }
        catch (Exception e) {
            throw new TrinoException(errorCode, String.format("Unable to set %s '%s' to [%s]: %s", propertyTypeDescription, property.getName(), expression, e.getMessage()), (Throwable)e);
        }
    }

    private static String capitalize(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }
}

