/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.scheduler.Exchanges;
import io.trino.operator.DirectExchangeBuffer;
import io.trino.operator.RetryPolicy;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.exchange.Exchange;
import io.trino.spi.exchange.ExchangeContext;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.exchange.ExchangeManager;
import io.trino.spi.exchange.ExchangeSink;
import io.trino.spi.exchange.ExchangeSinkHandle;
import io.trino.spi.exchange.ExchangeSource;
import io.trino.spi.exchange.ExchangeSourceOutputSelector;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

public class DeduplicatingDirectExchangeBuffer
implements DirectExchangeBuffer {
    private static final Logger log = Logger.get(DeduplicatingDirectExchangeBuffer.class);
    private final Executor executor;
    private final RetryPolicy retryPolicy;
    @GuardedBy(value="this")
    private final Set<TaskId> allTasks = new HashSet<TaskId>();
    @GuardedBy(value="this")
    private boolean noMoreTasks;
    @GuardedBy(value="this")
    private final Set<TaskId> successfulTasks = new HashSet<TaskId>();
    @GuardedBy(value="this")
    private final Map<TaskId, Throwable> failedTasks = new HashMap<TaskId, Throwable>();
    @GuardedBy(value="this")
    private int maxAttemptId;
    @GuardedBy(value="this")
    private final PageBuffer pageBuffer;
    private final SettableFuture<Void> outputReady = SettableFuture.create();
    @GuardedBy(value="this")
    private OutputSource outputSource;
    @GuardedBy(value="this")
    private long maxRetainedSizeInBytes;
    @GuardedBy(value="this")
    private Throwable failure;
    @GuardedBy(value="this")
    private boolean closed;

    public DeduplicatingDirectExchangeBuffer(Executor executor, DataSize bufferCapacity, RetryPolicy retryPolicy, ExchangeManagerRegistry exchangeManagerRegistry, QueryId queryId, ExchangeId exchangeId) {
        this.executor = Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(retryPolicy, "retryPolicy is null");
        Preconditions.checkArgument((retryPolicy != RetryPolicy.NONE ? 1 : 0) != 0, (Object)"retries should be enabled");
        this.retryPolicy = retryPolicy;
        this.pageBuffer = new PageBuffer(exchangeManagerRegistry, queryId, exchangeId, executor, bufferCapacity);
    }

    @Override
    public synchronized ListenableFuture<Void> isBlocked() {
        if (this.failure != null || this.closed) {
            return Futures.immediateVoidFuture();
        }
        if (!this.outputReady.isDone()) {
            return Futures.nonCancellationPropagating((ListenableFuture)Futures.transformAsync(this.outputReady, ignored -> {
                DeduplicatingDirectExchangeBuffer deduplicatingDirectExchangeBuffer = this;
                synchronized (deduplicatingDirectExchangeBuffer) {
                    if (this.outputSource != null) {
                        return this.outputSource.isBlocked();
                    }
                    return Futures.immediateVoidFuture();
                }
            }, (Executor)MoreExecutors.directExecutor()));
        }
        Preconditions.checkState((this.outputSource != null ? 1 : 0) != 0, (Object)"outputSource is expected to be set");
        return this.outputSource.isBlocked();
    }

    @Override
    public synchronized Slice pollPage() {
        this.throwIfFailed();
        if (this.closed) {
            return null;
        }
        if (!this.outputReady.isDone()) {
            return null;
        }
        Preconditions.checkState((this.outputSource != null ? 1 : 0) != 0, (Object)"outputSource is expected to be set");
        Slice page = this.outputSource.getNext();
        this.updateMaxRetainedSize();
        return page;
    }

    @Override
    public synchronized void addTask(TaskId taskId) {
        if (this.closed) {
            return;
        }
        Preconditions.checkState((!this.noMoreTasks ? 1 : 0) != 0, (Object)"no more tasks expected");
        Preconditions.checkState((boolean)this.allTasks.add(taskId), (String)"task already registered: %s", (Object)taskId);
        if (taskId.getAttemptId() > this.maxAttemptId) {
            this.maxAttemptId = taskId.getAttemptId();
            if (this.retryPolicy == RetryPolicy.QUERY) {
                this.pageBuffer.removePagesForPreviousAttempts(this.maxAttemptId);
                this.updateMaxRetainedSize();
            }
        }
    }

    @Override
    public synchronized void addPages(TaskId taskId, List<Slice> pages) {
        if (this.closed) {
            return;
        }
        if (this.failure != null) {
            return;
        }
        Preconditions.checkState((boolean)this.allTasks.contains(taskId), (String)"task is not registered: %s", (Object)taskId);
        Preconditions.checkState((!this.successfulTasks.contains(taskId) ? 1 : 0) != 0, (String)"task is finished: %s", (Object)taskId);
        Preconditions.checkState((!this.failedTasks.containsKey(taskId) ? 1 : 0) != 0, (String)"task is failed: %s", (Object)taskId);
        if (this.retryPolicy == RetryPolicy.QUERY && taskId.getAttemptId() < this.maxAttemptId) {
            return;
        }
        try {
            this.pageBuffer.addPages(taskId, pages);
            this.updateMaxRetainedSize();
        }
        catch (RuntimeException e) {
            this.fail(e);
        }
    }

    @Override
    public synchronized void taskFinished(TaskId taskId) {
        if (this.closed) {
            return;
        }
        Preconditions.checkState((boolean)this.allTasks.contains(taskId), (String)"task is not registered: %s", (Object)taskId);
        Preconditions.checkState((!this.failedTasks.containsKey(taskId) ? 1 : 0) != 0, (String)"task is failed: %s", (Object)taskId);
        Preconditions.checkState((boolean)this.successfulTasks.add(taskId), (String)"task is finished: %s", (Object)taskId);
        this.checkInputFinished();
    }

    @Override
    public synchronized void taskFailed(TaskId taskId, Throwable t) {
        if (this.closed) {
            return;
        }
        Preconditions.checkState((boolean)this.allTasks.contains(taskId), (String)"task is not registered: %s", (Object)taskId);
        Preconditions.checkState((!this.successfulTasks.contains(taskId) ? 1 : 0) != 0, (String)"task is finished: %s", (Object)taskId);
        Preconditions.checkState((this.failedTasks.put(taskId, t) == null ? 1 : 0) != 0, (String)"task is already failed: %s", (Object)taskId);
        this.checkInputFinished();
    }

    @Override
    public synchronized void noMoreTasks() {
        if (this.closed) {
            return;
        }
        this.noMoreTasks = true;
        this.checkInputFinished();
    }

    private void checkInputFinished() {
        Map failures;
        if (this.failure != null) {
            return;
        }
        if (this.outputSource != null) {
            return;
        }
        if (!this.noMoreTasks) {
            return;
        }
        switch (this.retryPolicy) {
            case TASK: {
                Set allPartitions = (Set)this.allTasks.stream().map(TaskId::getPartitionId).collect(ImmutableSet.toImmutableSet());
                Set successfulPartitions = (Set)this.successfulTasks.stream().map(TaskId::getPartitionId).collect(ImmutableSet.toImmutableSet());
                if (successfulPartitions.containsAll(allPartitions)) {
                    HashMap<Integer, TaskId> partitionToTaskMap = new HashMap<Integer, TaskId>();
                    for (TaskId successfulTaskId : this.successfulTasks) {
                        Integer partitionId = successfulTaskId.getPartitionId();
                        TaskId existing = (TaskId)partitionToTaskMap.get(partitionId);
                        if (existing != null && existing.getAttemptId() <= successfulTaskId.getAttemptId()) continue;
                        partitionToTaskMap.put(partitionId, successfulTaskId);
                    }
                    this.outputSource = this.pageBuffer.createOutputSource((Set<TaskId>)ImmutableSet.copyOf(partitionToTaskMap.values()));
                    this.unblock(this.outputReady);
                    return;
                }
                Set runningPartitions = (Set)this.allTasks.stream().filter(taskId -> !this.successfulTasks.contains(taskId)).filter(taskId -> !this.failedTasks.containsKey(taskId)).map(TaskId::getPartitionId).collect(ImmutableSet.toImmutableSet());
                failures = (Map)this.failedTasks.entrySet().stream().filter(entry -> !successfulPartitions.contains(((TaskId)entry.getKey()).getPartitionId())).filter(entry -> !runningPartitions.contains(((TaskId)entry.getKey()).getPartitionId())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
                break;
            }
            case QUERY: {
                Set latestAttemptTasks = (Set)this.allTasks.stream().filter(taskId -> taskId.getAttemptId() == this.maxAttemptId).collect(ImmutableSet.toImmutableSet());
                if (this.successfulTasks.containsAll(latestAttemptTasks)) {
                    this.outputSource = this.pageBuffer.createOutputSource(latestAttemptTasks);
                    this.unblock(this.outputReady);
                    return;
                }
                failures = (Map)this.failedTasks.entrySet().stream().filter(entry -> ((TaskId)entry.getKey()).getAttemptId() == this.maxAttemptId).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
                break;
            }
            default: {
                throw new UnsupportedOperationException("unexpected retry policy: " + this.retryPolicy);
            }
        }
        Throwable failure = null;
        for (Map.Entry entry2 : failures.entrySet()) {
            TaskId taskId2 = (TaskId)entry2.getKey();
            Throwable taskFailure = (Throwable)entry2.getValue();
            if (taskFailure instanceof TrinoException && StandardErrorCode.REMOTE_TASK_FAILED.toErrorCode().equals((Object)((TrinoException)taskFailure).getErrorCode())) {
                log.debug("Task failure discovered while fetching task results: %s", new Object[]{taskId2});
                continue;
            }
            if (failure == null) {
                failure = taskFailure;
                continue;
            }
            if (failure == taskFailure) continue;
            failure.addSuppressed(taskFailure);
        }
        if (failure != null) {
            this.fail(failure);
        }
    }

    @Override
    public synchronized boolean isFinished() {
        return this.failure == null && (this.closed || this.outputSource != null && this.outputSource.isFinished());
    }

    @Override
    public synchronized boolean isFailed() {
        return this.failure != null;
    }

    @Override
    public synchronized long getRemainingCapacityInBytes() {
        return Long.MAX_VALUE;
    }

    @Override
    public synchronized long getRetainedSizeInBytes() {
        long retainedSizeInBytes = this.pageBuffer.getRetainedSizeInBytes();
        if (this.outputSource != null) {
            retainedSizeInBytes += this.outputSource.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    @Override
    public synchronized long getMaxRetainedSizeInBytes() {
        return this.maxRetainedSizeInBytes;
    }

    @Override
    public int getBufferedPageCount() {
        return this.pageBuffer.getBufferedPageCount();
    }

    @Override
    public long getSpilledBytes() {
        return this.pageBuffer.getSpilledBytes();
    }

    @Override
    public int getSpilledPageCount() {
        return this.pageBuffer.getSpilledPageCount();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeAndUnblock();
    }

    private void fail(Throwable failure) {
        this.failure = failure;
        this.closeAndUnblock();
    }

    private void throwIfFailed() {
        if (this.failure != null) {
            Throwables.throwIfUnchecked((Throwable)this.failure);
            throw new RuntimeException(this.failure);
        }
    }

    private void closeAndUnblock() {
        try (Closer closer = Closer.create();){
            closer.register((Closeable)this.pageBuffer);
            closer.register((Closeable)this.outputSource);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.unblock(this.outputReady);
        }
    }

    private void updateMaxRetainedSize() {
        this.maxRetainedSizeInBytes = Math.max(this.maxRetainedSizeInBytes, this.getRetainedSizeInBytes());
    }

    private void unblock(SettableFuture<Void> blocked) {
        this.executor.execute(() -> blocked.set(null));
    }

    @ThreadSafe
    private static class PageBuffer
    implements Closeable {
        private final ExchangeManagerRegistry exchangeManagerRegistry;
        private final QueryId queryId;
        private final ExchangeId exchangeId;
        private final Executor executor;
        private final long pageBufferCapacityInBytes;
        @GuardedBy(value="this")
        private final ListMultimap<TaskId, Slice> pageBuffer = ArrayListMultimap.create();
        @GuardedBy(value="this")
        private long pageBufferRetainedSizeInBytes;
        @GuardedBy(value="this")
        private ExchangeManager exchangeManager;
        @GuardedBy(value="this")
        private Exchange exchange;
        @GuardedBy(value="this")
        private ExchangeSinkHandle sinkHandle;
        @GuardedBy(value="this")
        private ExchangeSink exchangeSink;
        @GuardedBy(value="this")
        private SliceOutput writeBuffer;
        @GuardedBy(value="this")
        private int bufferedPageCount;
        @GuardedBy(value="this")
        private long spilledBytes;
        @GuardedBy(value="this")
        private int spilledPageCount;
        @GuardedBy(value="this")
        private boolean inputFinished;
        @GuardedBy(value="this")
        private boolean closed;

        private PageBuffer(ExchangeManagerRegistry exchangeManagerRegistry, QueryId queryId, ExchangeId exchangeId, Executor executor, DataSize pageBufferCapacity) {
            this.exchangeManagerRegistry = Objects.requireNonNull(exchangeManagerRegistry, "exchangeManagerRegistry is null");
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.exchangeId = Objects.requireNonNull(exchangeId, "exchangeId is null");
            this.executor = Objects.requireNonNull(executor, "executor is null");
            this.pageBufferCapacityInBytes = pageBufferCapacity.toBytes();
        }

        public synchronized void addPages(TaskId taskId, List<Slice> pages) {
            if (this.closed) {
                return;
            }
            if (this.inputFinished) {
                return;
            }
            long pagesRetainedSizeInBytes = PageBuffer.getRetainedSizeInBytes(pages);
            if (this.exchangeSink == null && this.pageBufferRetainedSizeInBytes + pagesRetainedSizeInBytes <= this.pageBufferCapacityInBytes) {
                this.pageBuffer.putAll((Object)taskId, pages);
                this.pageBufferRetainedSizeInBytes += pagesRetainedSizeInBytes;
                this.bufferedPageCount += pages.size();
                return;
            }
            if (this.exchangeSink == null) {
                Verify.verify((this.exchangeManager == null ? 1 : 0) != 0, (String)"exchangeManager is not expected to be initialized", (Object[])new Object[0]);
                Verify.verify((this.exchange == null ? 1 : 0) != 0, (String)"exchange is not expected to be initialized", (Object[])new Object[0]);
                Verify.verify((this.sinkHandle == null ? 1 : 0) != 0, (String)"sinkHandle is not expected to be initialized", (Object[])new Object[0]);
                Verify.verify((this.writeBuffer == null ? 1 : 0) != 0, (String)"writeBuffer is not expected to be initialized", (Object[])new Object[0]);
                this.exchangeManager = this.exchangeManagerRegistry.getExchangeManager();
                this.exchange = this.exchangeManager.createExchange(new ExchangeContext(this.queryId, this.exchangeId), 1, true);
                this.sinkHandle = this.exchange.addSink(0);
                this.exchange.noMoreSinks();
                this.exchangeSink = this.exchangeManager.createSink(this.exchange.instantiateSink(this.sinkHandle, 0));
                this.writeBuffer = new DynamicSliceOutput(0x100000);
            }
            if (!this.pageBuffer.isEmpty()) {
                for (Map.Entry entry : Multimaps.asMap(this.pageBuffer).entrySet()) {
                    this.writeToSink((TaskId)entry.getKey(), (List)entry.getValue());
                }
                this.pageBuffer.clear();
                this.pageBufferRetainedSizeInBytes = 0L;
            }
            this.writeToSink(taskId, pages);
            this.bufferedPageCount += pages.size();
        }

        private static long getRetainedSizeInBytes(List<Slice> pages) {
            long result = 0L;
            for (Slice page : pages) {
                result += page.getRetainedSize();
            }
            return result;
        }

        private void writeToSink(TaskId taskId, List<Slice> pages) {
            Verify.verify((this.exchangeSink != null ? 1 : 0) != 0, (String)"exchangeSink is expected to be initialized", (Object[])new Object[0]);
            Verify.verify((this.writeBuffer != null ? 1 : 0) != 0, (String)"writeBuffer is expected to be initialized", (Object[])new Object[0]);
            for (Slice page : pages) {
                while (true) {
                    try {
                        this.exchangeSink.isBlocked().get(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                    catch (TimeoutException e) {
                        this.updateSinkInstanceHandleIfNecessary();
                        continue;
                    }
                    break;
                }
                this.writeBuffer.writeInt(taskId.getStageId().getId());
                this.writeBuffer.writeInt(taskId.getPartitionId());
                this.writeBuffer.writeInt(taskId.getAttemptId());
                this.writeBuffer.writeBytes(page);
                this.exchangeSink.add(0, Slices.copyOf((Slice)this.writeBuffer.slice()));
                this.writeBuffer.reset();
                this.spilledBytes += (long)page.length();
                ++this.spilledPageCount;
            }
        }

        private void updateSinkInstanceHandleIfNecessary() {
            Verify.verify((boolean)Thread.holdsLock(this), (String)"this method is expected to be called under a lock", (Object[])new Object[0]);
            Verify.verify((this.exchange != null ? 1 : 0) != 0, (String)"exchange is null", (Object[])new Object[0]);
            Verify.verify((this.exchangeSink != null ? 1 : 0) != 0, (String)"exchangeSink is null", (Object[])new Object[0]);
            Verify.verify((this.sinkHandle != null ? 1 : 0) != 0, (String)"sinkHandle is null", (Object[])new Object[0]);
            if (this.exchangeSink.isHandleUpdateRequired()) {
                this.exchangeSink.updateHandle(this.exchange.updateSinkInstanceHandle(this.sinkHandle, 0));
            }
        }

        public synchronized void removePagesForPreviousAttempts(int currentAttemptId) {
            Preconditions.checkState((!this.inputFinished ? 1 : 0) != 0, (Object)"input is finished");
            if (this.closed) {
                return;
            }
            long removedPagesRetainedSizeInBytes = 0L;
            int removedPagesCount = 0;
            Iterator iterator = Multimaps.asMap(this.pageBuffer).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TaskId taskId = (TaskId)entry.getKey();
                if (taskId.getAttemptId() >= currentAttemptId) continue;
                for (Slice page : (List)entry.getValue()) {
                    removedPagesRetainedSizeInBytes += page.getRetainedSize();
                    ++removedPagesCount;
                }
                iterator.remove();
            }
            this.pageBufferRetainedSizeInBytes -= removedPagesRetainedSizeInBytes;
            this.bufferedPageCount -= removedPagesCount;
        }

        public synchronized OutputSource createOutputSource(Set<TaskId> selectedTasks) {
            Preconditions.checkState((!this.inputFinished ? 1 : 0) != 0, (Object)"input is already marked as finished and page source has already been created");
            this.inputFinished = true;
            if (this.exchangeSink == null) {
                Iterator<Slice> iterator = this.pageBuffer.entries().stream().filter(entry -> selectedTasks.contains(entry.getKey())).map(Map.Entry::getValue).iterator();
                return new InMemoryBufferOutputSource(iterator);
            }
            Verify.verify((this.exchangeManager != null ? 1 : 0) != 0, (String)"exchangeManager is expected to be initialized", (Object[])new Object[0]);
            Verify.verify((this.exchange != null ? 1 : 0) != 0, (String)"exchange is expected to be initialized", (Object[])new Object[0]);
            Verify.verify((this.sinkHandle != null ? 1 : 0) != 0, (String)"sinkHandle is expected to be initialized", (Object[])new Object[0]);
            this.writeBuffer = null;
            FluentFuture exchangeSourceFuture = FluentFuture.from((ListenableFuture)MoreFutures.toListenableFuture((CompletableFuture)this.exchangeSink.finish())).transformAsync(ignored -> {
                this.exchange.sinkFinished(this.sinkHandle, 0);
                this.exchange.allRequiredSinksFinished();
                PageBuffer pageBuffer = this;
                synchronized (pageBuffer) {
                    this.exchangeSink = null;
                    this.sinkHandle = null;
                }
                return Exchanges.getAllSourceHandles(this.exchange.getSourceHandles());
            }, this.executor).transform(handles -> {
                ExchangeSource source = this.exchangeManager.createSource();
                try {
                    source.setOutputSelector(ExchangeSourceOutputSelector.builder((Set)ImmutableSet.of((Object)this.exchangeId)).include(this.exchangeId, 0, 0).setPartitionCount(this.exchangeId, 1).setFinal().build());
                    source.addSourceHandles(handles);
                    source.noMoreSourceHandles();
                    return source;
                }
                catch (Throwable t) {
                    block4: {
                        try {
                            source.close();
                        }
                        catch (Throwable closeFailure) {
                            if (closeFailure == t) break block4;
                            t.addSuppressed(closeFailure);
                        }
                    }
                    throw t;
                }
            }, this.executor);
            return new ExchangeOutputSource(selectedTasks, this.queryId, (ListenableFuture<ExchangeSource>)exchangeSourceFuture);
        }

        public synchronized long getRetainedSizeInBytes() {
            long result = this.pageBufferRetainedSizeInBytes;
            if (this.exchangeSink != null) {
                result += this.exchangeSink.getMemoryUsage();
            }
            if (this.writeBuffer != null) {
                result += this.writeBuffer.getRetainedSize();
            }
            return result;
        }

        public synchronized int getBufferedPageCount() {
            return this.bufferedPageCount;
        }

        public synchronized long getSpilledBytes() {
            return this.spilledBytes;
        }

        public synchronized int getSpilledPageCount() {
            return this.spilledPageCount;
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.pageBuffer.clear();
            this.pageBufferRetainedSizeInBytes = 0L;
            this.bufferedPageCount = 0;
            this.writeBuffer = null;
            if (this.exchangeSink != null) {
                try {
                    this.exchangeSink.abort().whenComplete((result, failure) -> {
                        if (failure != null) {
                            log.warn(failure, "Error aborting exchange sink");
                        }
                    });
                }
                catch (RuntimeException e) {
                    log.warn((Throwable)e, "Error aborting exchange sink");
                }
                this.exchangeSink = null;
            }
            if (this.exchange != null) {
                this.exchange.close();
            }
        }
    }

    @NotThreadSafe
    private static interface OutputSource
    extends Closeable {
        public Slice getNext();

        public boolean isFinished();

        public ListenableFuture<Void> isBlocked();

        public long getRetainedSizeInBytes();
    }

    @NotThreadSafe
    private static class ExchangeOutputSource
    implements OutputSource {
        private final Set<TaskId> selectedTasks;
        private final QueryId queryId;
        private ListenableFuture<ExchangeSource> exchangeSourceFuture;
        private ExchangeSource exchangeSource;
        private boolean finished;

        private ExchangeOutputSource(Set<TaskId> selectedTasks, QueryId queryId, ListenableFuture<ExchangeSource> exchangeSourceFuture) {
            this.selectedTasks = ImmutableSet.copyOf((Collection)Objects.requireNonNull(selectedTasks, "selectedTasks is null"));
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.exchangeSourceFuture = Objects.requireNonNull(exchangeSourceFuture, "exchangeSourceFuture is null");
        }

        @Override
        public Slice getNext() {
            if (this.finished) {
                return null;
            }
            if (this.exchangeSource == null) {
                if (!this.exchangeSourceFuture.isDone()) {
                    return null;
                }
                this.exchangeSource = (ExchangeSource)MoreFutures.getFutureValue(this.exchangeSourceFuture);
            }
            while (!this.exchangeSource.isFinished()) {
                int attemptId;
                int partitionId;
                int stageId;
                TaskId taskId;
                if (!this.exchangeSource.isBlocked().isDone()) {
                    return null;
                }
                Slice buffer = this.exchangeSource.read();
                if (buffer == null || !this.selectedTasks.contains(taskId = new TaskId(new StageId(this.queryId, stageId = buffer.getInt(0)), partitionId = buffer.getInt(4), attemptId = buffer.getInt(8)))) continue;
                return buffer.slice(12, buffer.length() - 12);
            }
            this.close();
            return null;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public ListenableFuture<Void> isBlocked() {
            CompletableFuture blocked;
            if (this.finished) {
                return Futures.immediateVoidFuture();
            }
            if (!this.exchangeSourceFuture.isDone()) {
                return Futures.nonCancellationPropagating((ListenableFuture)MoreFutures.asVoid((ListenableFuture)Futures.transformAsync(this.exchangeSourceFuture, exchangeSource -> MoreFutures.toListenableFuture((CompletableFuture)exchangeSource.isBlocked()), (Executor)MoreExecutors.directExecutor())));
            }
            if (this.exchangeSource != null && !(blocked = this.exchangeSource.isBlocked()).isDone()) {
                return Futures.nonCancellationPropagating((ListenableFuture)MoreFutures.toListenableFuture((CompletableFuture)blocked));
            }
            return Futures.immediateVoidFuture();
        }

        @Override
        public long getRetainedSizeInBytes() {
            if (this.exchangeSource != null) {
                return this.exchangeSource.getMemoryUsage();
            }
            return 0L;
        }

        @Override
        public void close() {
            if (this.finished) {
                return;
            }
            this.finished = true;
            this.exchangeSource = null;
            Futures.addCallback(this.exchangeSourceFuture, (FutureCallback)new FutureCallback<ExchangeSource>(){

                public void onSuccess(ExchangeSource exchangeSource) {
                    try {
                        exchangeSource.close();
                    }
                    catch (RuntimeException e) {
                        log.warn((Throwable)e, "error closing exchange source");
                    }
                }

                public void onFailure(Throwable ignored) {
                }
            }, (Executor)MoreExecutors.directExecutor());
            this.exchangeSourceFuture = null;
        }
    }

    @NotThreadSafe
    private static class InMemoryBufferOutputSource
    implements OutputSource {
        private final Iterator<Slice> iterator;

        private InMemoryBufferOutputSource(Iterator<Slice> iterator) {
            this.iterator = Objects.requireNonNull(iterator, "iterator is null");
        }

        @Override
        public Slice getNext() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            return this.iterator.next();
        }

        @Override
        public boolean isFinished() {
            return !this.iterator.hasNext();
        }

        @Override
        public ListenableFuture<Void> isBlocked() {
            return Futures.immediateVoidFuture();
        }

        @Override
        public long getRetainedSizeInBytes() {
            return 0L;
        }

        @Override
        public void close() {
        }
    }
}

