/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.trino.connector.CatalogHandle;
import io.trino.exchange.ExchangeDataSource;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.exchange.LazyExchangeDataSource;
import io.trino.execution.TaskId;
import io.trino.execution.buffer.PagesSerde;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.metadata.Split;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.operator.DriverContext;
import io.trino.operator.OperatorContext;
import io.trino.operator.RetryPolicy;
import io.trino.operator.SourceOperator;
import io.trino.operator.SourceOperatorFactory;
import io.trino.operator.TaskContext;
import io.trino.spi.Page;
import io.trino.spi.connector.UpdatablePageSource;
import io.trino.spi.exchange.ExchangeId;
import io.trino.split.RemoteSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

public class ExchangeOperator
implements SourceOperator {
    public static final CatalogHandle REMOTE_CATALOG_HANDLE = CatalogHandle.createRootCatalogHandle("$remote");
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final ExchangeDataSource exchangeDataSource;
    private final PagesSerde serde;
    private final NoMoreSplitsTracker noMoreSplitsTracker;
    private final int operatorInstanceId;
    private ListenableFuture<Void> isBlocked = NOT_BLOCKED;

    public ExchangeOperator(OperatorContext operatorContext, PlanNodeId sourceId, ExchangeDataSource exchangeDataSource, PagesSerde serde, NoMoreSplitsTracker noMoreSplitsTracker, int operatorInstanceId) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.exchangeDataSource = Objects.requireNonNull(exchangeDataSource, "exchangeDataSource is null");
        this.serde = Objects.requireNonNull(serde, "serde is null");
        this.noMoreSplitsTracker = Objects.requireNonNull(noMoreSplitsTracker, "noMoreSplitsTracker is null");
        this.operatorInstanceId = operatorInstanceId;
        operatorContext.setInfoSupplier(exchangeDataSource::getInfo);
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkArgument((boolean)split.getCatalogHandle().equals(REMOTE_CATALOG_HANDLE), (Object)"split is not a remote split");
        RemoteSplit remoteSplit = (RemoteSplit)split.getConnectorSplit();
        this.exchangeDataSource.addInput(remoteSplit.getExchangeInput());
        return Optional::empty;
    }

    @Override
    public void noMoreSplits() {
        this.noMoreSplitsTracker.noMoreSplits(this.operatorInstanceId);
        if (this.noMoreSplitsTracker.isNoMoreSplits()) {
            this.exchangeDataSource.noMoreInputs();
        }
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.close();
    }

    @Override
    public boolean isFinished() {
        return this.exchangeDataSource.isFinished();
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.isBlocked.isDone()) {
            this.isBlocked = this.exchangeDataSource.isBlocked();
            if (this.isBlocked.isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot take input");
    }

    @Override
    public Page getOutput() {
        Slice page = this.exchangeDataSource.pollPage();
        if (page == null) {
            return null;
        }
        Page deserializedPage = this.serde.deserialize(page);
        this.operatorContext.recordNetworkInput(page.length(), deserializedPage.getPositionCount());
        this.operatorContext.recordProcessedInput(deserializedPage.getSizeInBytes(), deserializedPage.getPositionCount());
        return deserializedPage;
    }

    @Override
    public void close() {
        this.exchangeDataSource.close();
    }

    @ThreadSafe
    private static class NoMoreSplitsTracker {
        private final IntSet allOperators = new IntOpenHashSet();
        private final IntSet noMoreSplitsOperators = new IntOpenHashSet();
        private boolean noMoreOperators;

        private NoMoreSplitsTracker() {
        }

        public synchronized void operatorAdded(int operatorInstanceId) {
            Preconditions.checkState((!this.noMoreOperators ? 1 : 0) != 0, (Object)"noMoreOperators is set");
            this.allOperators.add(operatorInstanceId);
        }

        public synchronized void noMoreOperators() {
            this.noMoreOperators = true;
        }

        public synchronized void noMoreSplits(int operatorInstanceId) {
            Preconditions.checkState((boolean)this.allOperators.contains(operatorInstanceId), (String)"operatorInstanceId not found: %s", (int)operatorInstanceId);
            this.noMoreSplitsOperators.add(operatorInstanceId);
        }

        public synchronized boolean isNoMoreSplits() {
            return this.noMoreOperators && this.noMoreSplitsOperators.containsAll((IntCollection)this.allOperators);
        }
    }

    public static class ExchangeOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final DirectExchangeClientSupplier directExchangeClientSupplier;
        private final PagesSerdeFactory serdeFactory;
        private final RetryPolicy retryPolicy;
        private final ExchangeManagerRegistry exchangeManagerRegistry;
        private ExchangeDataSource exchangeDataSource;
        private boolean closed;
        private final NoMoreSplitsTracker noMoreSplitsTracker = new NoMoreSplitsTracker();
        private int nextOperatorInstanceId;

        public ExchangeOperatorFactory(int operatorId, PlanNodeId sourceId, DirectExchangeClientSupplier directExchangeClientSupplier, PagesSerdeFactory serdeFactory, RetryPolicy retryPolicy, ExchangeManagerRegistry exchangeManagerRegistry) {
            this.operatorId = operatorId;
            this.sourceId = sourceId;
            this.directExchangeClientSupplier = directExchangeClientSupplier;
            this.serdeFactory = serdeFactory;
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy is null");
            this.exchangeManagerRegistry = Objects.requireNonNull(exchangeManagerRegistry, "exchangeManagerRegistry is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            TaskContext taskContext = driverContext.getPipelineContext().getTaskContext();
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, ExchangeOperator.class.getSimpleName());
            LocalMemoryContext memoryContext = driverContext.getPipelineContext().localMemoryContext();
            if (this.exchangeDataSource == null) {
                TaskId taskId = taskContext.getTaskId();
                this.exchangeDataSource = new LazyExchangeDataSource(taskId.getQueryId(), new ExchangeId(String.format("direct-exchange-%s-%s", taskId.getStageId().getId(), this.sourceId)), this.directExchangeClientSupplier, memoryContext, taskContext::sourceTaskFailed, this.retryPolicy, this.exchangeManagerRegistry);
            }
            int operatorInstanceId = this.nextOperatorInstanceId++;
            ExchangeOperator exchangeOperator = new ExchangeOperator(operatorContext, this.sourceId, this.exchangeDataSource, this.serdeFactory.createPagesSerde(), this.noMoreSplitsTracker, operatorInstanceId);
            this.noMoreSplitsTracker.operatorAdded(operatorInstanceId);
            return exchangeOperator;
        }

        @Override
        public void noMoreOperators() {
            this.noMoreSplitsTracker.noMoreOperators();
            if (this.noMoreSplitsTracker.isNoMoreSplits() && this.exchangeDataSource != null) {
                this.exchangeDataSource.noMoreInputs();
            }
            this.closed = true;
        }
    }
}

