/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.slice.Slice;
import io.trino.exchange.DirectExchangeInput;
import io.trino.execution.buffer.PagesSerde;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.metadata.Split;
import io.trino.operator.DirectExchangeClient;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.operator.DriverContext;
import io.trino.operator.OperatorContext;
import io.trino.operator.PageWithPositionComparator;
import io.trino.operator.RetryPolicy;
import io.trino.operator.SourceOperator;
import io.trino.operator.SourceOperatorFactory;
import io.trino.operator.TaskContext;
import io.trino.operator.WorkProcessor;
import io.trino.spi.Page;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.connector.UpdatablePageSource;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.type.Type;
import io.trino.split.RemoteSplit;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.util.MergeSortedPages;
import io.trino.util.MoreLists;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class MergeOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final DirectExchangeClientSupplier directExchangeClientSupplier;
    private final PagesSerde pagesSerde;
    private final PageWithPositionComparator comparator;
    private final List<Integer> outputChannels;
    private final List<Type> outputTypes;
    private final SettableFuture<Void> blockedOnSplits = SettableFuture.create();
    private final List<WorkProcessor<Page>> pageProducers = new ArrayList<WorkProcessor<Page>>();
    private final Closer closer = Closer.create();
    private WorkProcessor<Page> mergedPages;
    private boolean closed;

    public MergeOperator(OperatorContext operatorContext, PlanNodeId sourceId, DirectExchangeClientSupplier directExchangeClientSupplier, PagesSerde pagesSerde, PageWithPositionComparator comparator, List<Integer> outputChannels, List<Type> outputTypes) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.directExchangeClientSupplier = Objects.requireNonNull(directExchangeClientSupplier, "directExchangeClientSupplier is null");
        this.pagesSerde = Objects.requireNonNull(pagesSerde, "pagesSerde is null");
        this.comparator = Objects.requireNonNull(comparator, "comparator is null");
        this.outputChannels = Objects.requireNonNull(outputChannels, "outputChannels is null");
        this.outputTypes = Objects.requireNonNull(outputTypes, "outputTypes is null");
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkArgument((boolean)(split.getConnectorSplit() instanceof RemoteSplit), (Object)"split is not a remote split");
        Preconditions.checkState((!this.blockedOnSplits.isDone() ? 1 : 0) != 0, (Object)"noMoreSplits has been called already");
        TaskContext taskContext = this.operatorContext.getDriverContext().getPipelineContext().getTaskContext();
        DirectExchangeClient client = (DirectExchangeClient)this.closer.register((Closeable)this.directExchangeClientSupplier.get(taskContext.getTaskId().getQueryId(), new ExchangeId(String.format("direct-exchange-merge-%s-%s", taskContext.getTaskId().getStageId().getId(), this.sourceId)), this.operatorContext.localUserMemoryContext(), taskContext::sourceTaskFailed, RetryPolicy.NONE));
        RemoteSplit remoteSplit = (RemoteSplit)split.getConnectorSplit();
        DirectExchangeInput exchangeInput = (DirectExchangeInput)remoteSplit.getExchangeInput();
        client.addLocation(exchangeInput.getTaskId(), URI.create(exchangeInput.getLocation()));
        client.noMoreLocations();
        this.pageProducers.add(client.pages().map(serializedPage -> {
            Page page = this.pagesSerde.deserialize((Slice)serializedPage);
            this.operatorContext.recordNetworkInput(serializedPage.length(), page.getPositionCount());
            return page;
        }));
        return Optional::empty;
    }

    @Override
    public void noMoreSplits() {
        this.mergedPages = MergeSortedPages.mergeSortedPages(this.pageProducers, this.comparator, this.outputChannels, this.outputTypes, (pageBuilder, pageWithPosition) -> pageBuilder.isFull(), false, this.operatorContext.aggregateUserMemoryContext(), this.operatorContext.getDriverContext().getYieldSignal());
        this.blockedOnSplits.set(null);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.close();
    }

    @Override
    public boolean isFinished() {
        return this.closed || this.mergedPages != null && this.mergedPages.isFinished();
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (!this.blockedOnSplits.isDone()) {
            return this.blockedOnSplits;
        }
        if (this.mergedPages.isBlocked()) {
            return this.mergedPages.getBlockedFuture();
        }
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot take input");
    }

    @Override
    public Page getOutput() {
        if (this.closed || this.mergedPages == null || !this.mergedPages.process() || this.mergedPages.isFinished()) {
            return null;
        }
        Page page = this.mergedPages.getResult();
        this.operatorContext.recordProcessedInput(page.getSizeInBytes(), page.getPositionCount());
        return page;
    }

    @Override
    public void close() {
        try {
            this.closer.close();
            this.closed = true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class MergeOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final DirectExchangeClientSupplier directExchangeClientSupplier;
        private final PagesSerdeFactory serdeFactory;
        private final List<Type> types;
        private final List<Integer> outputChannels;
        private final List<Type> outputTypes;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrder;
        private final OrderingCompiler orderingCompiler;
        private boolean closed;

        public MergeOperatorFactory(int operatorId, PlanNodeId sourceId, DirectExchangeClientSupplier directExchangeClientSupplier, PagesSerdeFactory serdeFactory, OrderingCompiler orderingCompiler, List<Type> types, List<Integer> outputChannels, List<Integer> sortChannels, List<SortOrder> sortOrder) {
            this.operatorId = operatorId;
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.directExchangeClientSupplier = Objects.requireNonNull(directExchangeClientSupplier, "directExchangeClientSupplier is null");
            this.serdeFactory = Objects.requireNonNull(serdeFactory, "serdeFactory is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.outputChannels = Objects.requireNonNull(outputChannels, "outputChannels is null");
            this.outputTypes = MoreLists.mappedCopy(outputChannels, types::get);
            this.sortChannels = Objects.requireNonNull(sortChannels, "sortChannels is null");
            this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder is null");
            this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, MergeOperator.class.getSimpleName());
            return new MergeOperator(operatorContext, this.sourceId, this.directExchangeClientSupplier, this.serdeFactory.createPagesSerde(), this.orderingCompiler.compilePageWithPositionComparator(this.types, this.sortChannels, this.sortOrder), this.outputChannels, this.outputTypes);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

