/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.operator.AbstractRowChangeOperator;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.type.TinyintType;
import io.trino.split.PageSinkId;
import io.trino.split.PageSinkManager;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableWriterNode;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.IntStream;

public class MergeWriterOperator
extends AbstractRowChangeOperator {
    private final ConnectorMergeSink mergeSink;
    private final Function<Page, Page> pagePreprocessor;

    public MergeWriterOperator(OperatorContext operatorContext, ConnectorMergeSink mergeSink, Function<Page, Page> pagePreprocessor) {
        super(operatorContext);
        this.mergeSink = Objects.requireNonNull(mergeSink, "mergeSink is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
    }

    @Override
    public void addInput(Page suppliedPage) {
        Objects.requireNonNull(suppliedPage, "suppliedPage is null");
        Page page = this.pagePreprocessor.apply(suppliedPage);
        Preconditions.checkState((this.state == AbstractRowChangeOperator.State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object)((Object)this.state));
        int outputChannelCount = page.getChannelCount() - 1;
        int[] columns = IntStream.range(0, outputChannelCount).toArray();
        Page newPage = page.getColumns(columns);
        this.mergeSink.storeMergedRows(newPage);
        Block insertFromUpdateColumn = page.getBlock(page.getChannelCount() - 1);
        long insertsFromUpdates = 0L;
        int positionCount = page.getPositionCount();
        for (int position = 0; position < positionCount; ++position) {
            insertsFromUpdates += TinyintType.TINYINT.getLong(insertFromUpdateColumn, position);
        }
        this.rowCount += (long)positionCount - insertsFromUpdates;
    }

    @Override
    public void finish() {
        if (this.state == AbstractRowChangeOperator.State.RUNNING) {
            this.state = AbstractRowChangeOperator.State.FINISHING;
            this.finishFuture = MoreFutures.toListenableFuture((CompletableFuture)this.mergeSink.finish());
        }
    }

    @Override
    protected void abort() {
        this.mergeSink.abort();
    }

    public static class MergeWriterOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PageSinkManager pageSinkManager;
        private final TableWriterNode.MergeTarget target;
        private final Session session;
        private final Function<Page, Page> pagePreprocessor;
        private boolean closed;

        public MergeWriterOperatorFactory(int operatorId, PlanNodeId planNodeId, PageSinkManager pageSinkManager, TableWriterNode.MergeTarget target, Session session, Function<Page, Page> pagePreprocessor) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
            this.target = Objects.requireNonNull(target, "target is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, MergeWriterOperator.class.getSimpleName());
            ConnectorMergeSink mergeSink = this.pageSinkManager.createMergeSink(this.session, this.target.getMergeHandle().orElseThrow(), PageSinkId.fromTaskId(driverContext.getTaskId()));
            return new MergeWriterOperator(context, mergeSink, this.pagePreprocessor);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new MergeWriterOperatorFactory(this.operatorId, this.planNodeId, this.pageSinkManager, this.target, this.session, this.pagePreprocessor);
        }
    }
}

