/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.OperatorFactory;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.LookupJoinOperatorFactory;
import io.trino.operator.join.LookupSourceFactory;
import io.trino.operator.join.unspilled.PartitionedLookupSourceFactory;
import io.trino.spi.type.Type;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.type.BlockTypeOperators;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public interface OperatorFactories {
    public OperatorFactory join(JoinOperatorType var1, int var2, PlanNodeId var3, JoinBridgeManager<? extends PartitionedLookupSourceFactory> var4, boolean var5, List<Type> var6, List<Integer> var7, OptionalInt var8, Optional<List<Integer>> var9, BlockTypeOperators var10);

    public OperatorFactory spillingJoin(JoinOperatorType var1, int var2, PlanNodeId var3, JoinBridgeManager<? extends LookupSourceFactory> var4, boolean var5, List<Type> var6, List<Integer> var7, OptionalInt var8, Optional<List<Integer>> var9, OptionalInt var10, PartitioningSpillerFactory var11, BlockTypeOperators var12);

    public static class JoinOperatorType {
        private final LookupJoinOperatorFactory.JoinType type;
        private final boolean outputSingleMatch;
        private final boolean waitForBuild;

        public static JoinOperatorType ofJoinNodeType(JoinNode.Type joinNodeType, boolean outputSingleMatch, boolean waitForBuild) {
            return switch (joinNodeType) {
                default -> throw new IncompatibleClassChangeError();
                case JoinNode.Type.INNER -> JoinOperatorType.innerJoin(outputSingleMatch, waitForBuild);
                case JoinNode.Type.LEFT -> JoinOperatorType.probeOuterJoin(outputSingleMatch);
                case JoinNode.Type.RIGHT -> JoinOperatorType.lookupOuterJoin(waitForBuild);
                case JoinNode.Type.FULL -> JoinOperatorType.fullOuterJoin();
            };
        }

        public static JoinOperatorType innerJoin(boolean outputSingleMatch, boolean waitForBuild) {
            return new JoinOperatorType(LookupJoinOperatorFactory.JoinType.INNER, outputSingleMatch, waitForBuild);
        }

        public static JoinOperatorType probeOuterJoin(boolean outputSingleMatch) {
            return new JoinOperatorType(LookupJoinOperatorFactory.JoinType.PROBE_OUTER, outputSingleMatch, false);
        }

        public static JoinOperatorType lookupOuterJoin(boolean waitForBuild) {
            return new JoinOperatorType(LookupJoinOperatorFactory.JoinType.LOOKUP_OUTER, false, waitForBuild);
        }

        public static JoinOperatorType fullOuterJoin() {
            return new JoinOperatorType(LookupJoinOperatorFactory.JoinType.FULL_OUTER, false, false);
        }

        private JoinOperatorType(LookupJoinOperatorFactory.JoinType type, boolean outputSingleMatch, boolean waitForBuild) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.outputSingleMatch = outputSingleMatch;
            this.waitForBuild = waitForBuild;
        }

        public boolean isOutputSingleMatch() {
            return this.outputSingleMatch;
        }

        public boolean isWaitForBuild() {
            return this.waitForBuild;
        }

        public LookupJoinOperatorFactory.JoinType getType() {
            return this.type;
        }
    }
}

