/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.Session;
import io.trino.execution.TaskId;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.OperatorContext;
import io.trino.operator.SpillContext;
import java.util.Objects;

public class ProcessorContext {
    private final Session session;
    private final MemoryTrackingContext memoryTrackingContext;
    private final DriverYieldSignal driverYieldSignal;
    private final SpillContext spillContext;
    private final TaskId taskId;

    public ProcessorContext(Session session, MemoryTrackingContext memoryTrackingContext, OperatorContext operatorContext) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.memoryTrackingContext = Objects.requireNonNull(memoryTrackingContext, "memoryTrackingContext is null");
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.driverYieldSignal = operatorContext.getDriverContext().getYieldSignal();
        this.spillContext = operatorContext.getSpillContext();
        this.taskId = operatorContext.getDriverContext().getTaskId();
    }

    public Session getSession() {
        return this.session;
    }

    public MemoryTrackingContext getMemoryTrackingContext() {
        return this.memoryTrackingContext;
    }

    public DriverYieldSignal getDriverYieldSignal() {
        return this.driverYieldSignal;
    }

    public SpillContext getSpillContext() {
        return this.spillContext;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }
}

