/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.Slices;
import io.trino.operator.aggregation.NullablePosition;
import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.VarbinaryType;
import java.lang.invoke.MethodHandle;

@AggregationFunction(value="checksum")
@Description(value="Checksum of the given values")
public final class ChecksumAggregationFunction {
    @VisibleForTesting
    public static final long PRIME64 = -7046029288634856825L;

    private ChecksumAggregationFunction() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle xxHash64Operator, @AggregationState NullableLongState state, @NullablePosition @BlockPosition @SqlType(value="T") Block block, @BlockIndex int position) throws Throwable {
        state.setNull(false);
        if (block.isNull(position)) {
            state.setValue(state.getValue() + -7046029288634856825L);
        } else {
            long valueHash = xxHash64Operator.invokeExact(block, position);
            state.setValue(state.getValue() + valueHash * -7046029288634856825L);
        }
    }

    @CombineFunction
    public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        state.setNull(state.isNull() && otherState.isNull());
        state.setValue(state.getValue() + otherState.getValue());
    }

    @OutputFunction(value="VARBINARY")
    public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedLongArray((long[])new long[]{state.getValue()}));
        }
    }
}

