/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.builder;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.DataSize;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.HashCollisionsCounter;
import io.trino.operator.MergeHashSort;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.Work;
import io.trino.operator.WorkProcessor;
import io.trino.operator.aggregation.AggregatorFactory;
import io.trino.operator.aggregation.builder.HashAggregationBuilder;
import io.trino.operator.aggregation.builder.InMemoryHashAggregationBuilder;
import io.trino.operator.aggregation.builder.MergingHashAggregationBuilder;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.spiller.Spiller;
import io.trino.spiller.SpillerFactory;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.type.BlockTypeOperators;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class SpillableHashAggregationBuilder
implements HashAggregationBuilder {
    private InMemoryHashAggregationBuilder hashAggregationBuilder;
    private final SpillerFactory spillerFactory;
    private final List<AggregatorFactory> aggregatorFactories;
    private final AggregationNode.Step step;
    private final int expectedGroups;
    private final List<Type> groupByTypes;
    private final List<Integer> groupByChannels;
    private final Optional<Integer> hashChannel;
    private final OperatorContext operatorContext;
    private final LocalMemoryContext localUserMemoryContext;
    private final LocalMemoryContext localRevocableMemoryContext;
    private final long memoryLimitForMerge;
    private final long memoryLimitForMergeWithMemory;
    private Optional<Spiller> spiller = Optional.empty();
    private Optional<MergingHashAggregationBuilder> merger = Optional.empty();
    private Optional<MergeHashSort> mergeHashSort = Optional.empty();
    private ListenableFuture<Void> spillInProgress = Futures.immediateVoidFuture();
    private final JoinCompiler joinCompiler;
    private final BlockTypeOperators blockTypeOperators;
    private long emptyHashAggregationBuilderSize;
    private long hashCollisions;
    private double expectedHashCollisions;
    private boolean producingOutput;

    public SpillableHashAggregationBuilder(List<AggregatorFactory> aggregatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> hashChannel, OperatorContext operatorContext, DataSize memoryLimitForMerge, DataSize memoryLimitForMergeWithMemory, SpillerFactory spillerFactory, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators) {
        this.aggregatorFactories = aggregatorFactories;
        this.step = step;
        this.expectedGroups = expectedGroups;
        this.groupByTypes = groupByTypes;
        this.groupByChannels = groupByChannels;
        this.hashChannel = hashChannel;
        this.operatorContext = operatorContext;
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        this.localRevocableMemoryContext = operatorContext.localRevocableMemoryContext();
        this.memoryLimitForMerge = memoryLimitForMerge.toBytes();
        this.memoryLimitForMergeWithMemory = memoryLimitForMergeWithMemory.toBytes();
        this.spillerFactory = spillerFactory;
        this.joinCompiler = joinCompiler;
        this.blockTypeOperators = blockTypeOperators;
        this.rebuildHashAggregationBuilder();
    }

    @Override
    public Work<?> processPage(Page page) {
        Preconditions.checkState((boolean)this.hasPreviousSpillCompletedSuccessfully(), (Object)"Previous spill hasn't yet finished");
        return this.hashAggregationBuilder.processPage(page);
    }

    @Override
    public void updateMemory() {
        Preconditions.checkState((boolean)this.spillInProgress.isDone());
        if (this.producingOutput) {
            this.localRevocableMemoryContext.setBytes(0L);
            this.localUserMemoryContext.setBytes(this.hashAggregationBuilder.getSizeInMemory());
        } else {
            this.localUserMemoryContext.setBytes(this.emptyHashAggregationBuilderSize);
            this.localRevocableMemoryContext.setBytes(this.hashAggregationBuilder.getSizeInMemory() - this.emptyHashAggregationBuilderSize);
        }
    }

    @Override
    public void recordHashCollisions(HashCollisionsCounter hashCollisionsCounter) {
        hashCollisionsCounter.recordHashCollision(this.hashCollisions, this.expectedHashCollisions);
        this.hashCollisions = 0L;
        this.expectedHashCollisions = 0.0;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    private boolean hasPreviousSpillCompletedSuccessfully() {
        if (this.spillInProgress.isDone()) {
            MoreFutures.getFutureValue(this.spillInProgress);
            return true;
        }
        return false;
    }

    @Override
    public ListenableFuture<Void> startMemoryRevoke() {
        if (this.producingOutput) {
            Verify.verify((this.localRevocableMemoryContext.getBytes() == 0L ? 1 : 0) != 0);
            return Operator.NOT_BLOCKED;
        }
        return this.spillToDisk();
    }

    @Override
    public void finishMemoryRevoke() {
        this.updateMemory();
    }

    private boolean shouldMergeWithMemory(long memorySize) {
        return memorySize < this.memoryLimitForMergeWithMemory;
    }

    @Override
    public WorkProcessor<Page> buildResult() {
        Preconditions.checkState((boolean)this.hasPreviousSpillCompletedSuccessfully(), (Object)"Previous spill hasn't yet finished");
        this.producingOutput = true;
        if (this.localRevocableMemoryContext.getBytes() > 0L) {
            long currentRevocableBytes = this.localRevocableMemoryContext.getBytes();
            this.localRevocableMemoryContext.setBytes(0L);
            if (!this.localUserMemoryContext.trySetBytes(this.localUserMemoryContext.getBytes() + currentRevocableBytes)) {
                this.localRevocableMemoryContext.setBytes(currentRevocableBytes);
                MoreFutures.getFutureValue(this.spillToDisk());
                this.updateMemory();
            }
        }
        if (this.spiller.isEmpty()) {
            return this.hashAggregationBuilder.buildResult();
        }
        if (this.shouldMergeWithMemory(this.getSizeInMemoryWhenUnspilling())) {
            return this.mergeFromDiskAndMemory();
        }
        MoreFutures.getFutureValue(this.spillToDisk());
        return this.mergeFromDisk();
    }

    private long getSizeInMemoryWhenUnspilling() {
        return this.hashAggregationBuilder.getSizeInMemory() + this.hashAggregationBuilder.getGroupIdsSortingSize();
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            if (this.hashAggregationBuilder != null) {
                closer.register(this.hashAggregationBuilder::close);
            }
            this.merger.ifPresent(arg_0 -> ((Closer)closer).register(arg_0));
            this.spiller.ifPresent(arg_0 -> ((Closer)closer).register(arg_0));
            this.mergeHashSort.ifPresent(arg_0 -> ((Closer)closer).register(arg_0));
            closer.register(() -> this.localUserMemoryContext.setBytes(0L));
            closer.register(() -> this.localRevocableMemoryContext.setBytes(0L));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ListenableFuture<Void> spillToDisk() {
        Preconditions.checkState((boolean)this.hasPreviousSpillCompletedSuccessfully(), (Object)"Previous spill hasn't yet finished");
        this.hashAggregationBuilder.setSpillOutput();
        if (this.spiller.isEmpty()) {
            this.spiller = Optional.of(this.spillerFactory.create(this.hashAggregationBuilder.buildTypes(), this.operatorContext.getSpillContext(), this.operatorContext.newAggregateUserMemoryContext()));
        }
        this.spillInProgress = this.spiller.get().spill(this.hashAggregationBuilder.buildHashSortedResult().iterator());
        this.rebuildHashAggregationBuilder();
        return this.spillInProgress;
    }

    private WorkProcessor<Page> mergeFromDiskAndMemory() {
        Preconditions.checkState((boolean)this.spiller.isPresent());
        this.hashAggregationBuilder.setSpillOutput();
        this.mergeHashSort = Optional.of(new MergeHashSort(this.operatorContext.newAggregateUserMemoryContext(), this.blockTypeOperators));
        WorkProcessor<Page> mergedSpilledPages = this.mergeHashSort.get().merge(this.groupByTypes, this.hashAggregationBuilder.buildSpillTypes(), (List<WorkProcessor<Page>>)ImmutableList.builder().addAll((Iterable)this.spiller.get().getSpills().stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList())).add(this.hashAggregationBuilder.buildHashSortedResult()).build(), this.operatorContext.getDriverContext().getYieldSignal());
        return this.mergeSortedPages(mergedSpilledPages, Math.max(this.memoryLimitForMerge - this.memoryLimitForMergeWithMemory, 1L));
    }

    private WorkProcessor<Page> mergeFromDisk() {
        Preconditions.checkState((boolean)this.spiller.isPresent());
        this.mergeHashSort = Optional.of(new MergeHashSort(this.operatorContext.newAggregateUserMemoryContext(), this.blockTypeOperators));
        WorkProcessor<Page> mergedSpilledPages = this.mergeHashSort.get().merge(this.groupByTypes, this.hashAggregationBuilder.buildSpillTypes(), (List)this.spiller.get().getSpills().stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList()), this.operatorContext.getDriverContext().getYieldSignal());
        return this.mergeSortedPages(mergedSpilledPages, this.memoryLimitForMerge);
    }

    private WorkProcessor<Page> mergeSortedPages(WorkProcessor<Page> sortedPages, long memoryLimitForMerge) {
        this.merger = Optional.of(new MergingHashAggregationBuilder(this.aggregatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.hashChannel, this.operatorContext, sortedPages, this.operatorContext.aggregateUserMemoryContext(), memoryLimitForMerge, this.hashAggregationBuilder.getKeyChannels(), this.joinCompiler, this.blockTypeOperators));
        return this.merger.get().buildResult();
    }

    private void rebuildHashAggregationBuilder() {
        if (this.hashAggregationBuilder != null) {
            this.hashCollisions += this.hashAggregationBuilder.getHashCollisions();
            this.expectedHashCollisions += this.hashAggregationBuilder.getExpectedHashCollisions();
            this.hashAggregationBuilder.close();
        }
        this.hashAggregationBuilder = new InMemoryHashAggregationBuilder(this.aggregatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.groupByChannels, this.hashChannel, this.operatorContext, Optional.of(DataSize.succinctBytes((long)0L)), this.joinCompiler, this.blockTypeOperators, () -> {
            this.updateMemory();
            return true;
        });
        this.emptyHashAggregationBuilderSize = this.hashAggregationBuilder.getSizeInMemory();
    }
}

