/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxbyn;

import com.google.common.base.Preconditions;
import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.minmaxbyn.MinMaxByNState;
import io.trino.operator.aggregation.minmaxbyn.TypedKeyValueHeap;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.GroupedAccumulatorState;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.openjdk.jol.info.ClassLayout;

public final class MinMaxByNStateFactory {

    public static abstract class SingleMinMaxByNState
    extends AbstractMinMaxByNState {
        private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(SingleMinMaxByNState.class).instanceSize());
        private final LongFunction<TypedKeyValueHeap> heapFactory;
        private final Function<Block, TypedKeyValueHeap> deserializer;
        private TypedKeyValueHeap typedHeap;

        public SingleMinMaxByNState(LongFunction<TypedKeyValueHeap> heapFactory, Function<Block, TypedKeyValueHeap> deserializer) {
            this.heapFactory = heapFactory;
            this.deserializer = deserializer;
        }

        protected SingleMinMaxByNState(SingleMinMaxByNState state) {
            this.heapFactory = state.heapFactory;
            this.deserializer = state.deserializer;
            this.typedHeap = state.typedHeap != null ? state.typedHeap.copy() : null;
        }

        public abstract AccumulatorState copy();

        public final long getEstimatedSize() {
            return (long)INSTANCE_SIZE + (this.typedHeap == null ? 0L : this.typedHeap.getEstimatedSize());
        }

        @Override
        public final void initialize(long n) {
            if (this.typedHeap == null) {
                this.typedHeap = this.heapFactory.apply(n);
            }
        }

        @Override
        public final void add(Block keyBlock, Block valueBlock, int position) {
            this.typedHeap.add(keyBlock, valueBlock, position);
        }

        @Override
        public final void merge(MinMaxByNState other) {
            TypedKeyValueHeap otherTypedHeap = ((AbstractMinMaxByNState)other).getTypedKeyValueHeap();
            if (otherTypedHeap == null) {
                return;
            }
            if (this.typedHeap == null) {
                this.typedHeap = otherTypedHeap;
            } else {
                this.typedHeap.addAll(otherTypedHeap);
            }
        }

        @Override
        public final void popAll(BlockBuilder out) {
            if (this.typedHeap == null || this.typedHeap.isEmpty()) {
                out.appendNull();
                return;
            }
            BlockBuilder arrayBlockBuilder = out.beginBlockEntry();
            this.typedHeap.popAllReverse(arrayBlockBuilder);
            out.closeEntry();
        }

        @Override
        public final void serialize(BlockBuilder out) {
            if (this.typedHeap == null) {
                out.appendNull();
            } else {
                this.typedHeap.serialize(out);
            }
        }

        @Override
        public final void deserialize(Block rowBlock) {
            this.typedHeap = this.deserializer.apply(rowBlock);
        }

        @Override
        final TypedKeyValueHeap getTypedKeyValueHeap() {
            return this.typedHeap;
        }
    }

    public static abstract class GroupedMinMaxByNState
    extends AbstractMinMaxByNState
    implements GroupedAccumulatorState {
        private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(GroupedMinMaxByNState.class).instanceSize());
        private final LongFunction<TypedKeyValueHeap> heapFactory;
        private final Function<Block, TypedKeyValueHeap> deserializer;
        private final ObjectBigArray<TypedKeyValueHeap> heaps = new ObjectBigArray();
        private long groupId;
        private long size;

        public GroupedMinMaxByNState(LongFunction<TypedKeyValueHeap> heapFactory, Function<Block, TypedKeyValueHeap> deserializer) {
            this.heapFactory = heapFactory;
            this.deserializer = deserializer;
        }

        public final void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        public final void ensureCapacity(long size) {
            this.heaps.ensureCapacity(size);
        }

        public final long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.heaps.sizeOf() + this.size;
        }

        @Override
        public final void initialize(long n) {
            if (this.getTypedKeyValueHeap() == null) {
                TypedKeyValueHeap typedHeap = this.heapFactory.apply(n);
                this.setTypedKeyValueHeap(typedHeap);
                this.size += typedHeap.getEstimatedSize();
            }
        }

        @Override
        public final void add(Block keyBlock, Block valueBlock, int position) {
            TypedKeyValueHeap typedHeap = this.getTypedKeyValueHeap();
            this.size -= typedHeap.getEstimatedSize();
            typedHeap.add(keyBlock, valueBlock, position);
            this.size += typedHeap.getEstimatedSize();
        }

        @Override
        public final void merge(MinMaxByNState other) {
            TypedKeyValueHeap otherTypedHeap = ((AbstractMinMaxByNState)other).getTypedKeyValueHeap();
            if (otherTypedHeap == null) {
                return;
            }
            TypedKeyValueHeap typedHeap = this.getTypedKeyValueHeap();
            if (typedHeap == null) {
                this.setTypedKeyValueHeap(otherTypedHeap);
                this.size += otherTypedHeap.getEstimatedSize();
            } else {
                this.size -= typedHeap.getEstimatedSize();
                typedHeap.addAll(otherTypedHeap);
                this.size += typedHeap.getEstimatedSize();
            }
        }

        @Override
        public final void popAll(BlockBuilder out) {
            TypedKeyValueHeap typedHeap = this.getTypedKeyValueHeap();
            if (typedHeap == null || typedHeap.isEmpty()) {
                out.appendNull();
                return;
            }
            BlockBuilder arrayBlockBuilder = out.beginBlockEntry();
            this.size -= typedHeap.getEstimatedSize();
            typedHeap.popAllReverse(arrayBlockBuilder);
            this.size += typedHeap.getEstimatedSize();
            out.closeEntry();
        }

        @Override
        public final void serialize(BlockBuilder out) {
            TypedKeyValueHeap typedHeap = this.getTypedKeyValueHeap();
            if (typedHeap == null) {
                out.appendNull();
            } else {
                typedHeap.serialize(out);
            }
        }

        @Override
        public final void deserialize(Block rowBlock) {
            Preconditions.checkState((this.getTypedKeyValueHeap() == null ? 1 : 0) != 0, (Object)"State already initialized");
            TypedKeyValueHeap typedHeap = this.deserializer.apply(rowBlock);
            this.setTypedKeyValueHeap(typedHeap);
            this.size += typedHeap.getEstimatedSize();
        }

        @Override
        final TypedKeyValueHeap getTypedKeyValueHeap() {
            return (TypedKeyValueHeap)this.heaps.get(this.groupId);
        }

        private void setTypedKeyValueHeap(TypedKeyValueHeap value) {
            this.heaps.set(this.groupId, (Object)value);
        }
    }

    private static abstract class AbstractMinMaxByNState
    implements MinMaxByNState {
        private AbstractMinMaxByNState() {
        }

        abstract TypedKeyValueHeap getTypedKeyValueHeap();
    }
}

