/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.multimapagg;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.multimapagg.MultimapAggregationState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class MultimapAggregationStateSerializer
implements AccumulatorStateSerializer<MultimapAggregationState> {
    private final Type keyType;
    private final Type valueType;
    private final ArrayType arrayType;

    public MultimapAggregationStateSerializer(@TypeParameter(value="K") Type keyType, @TypeParameter(value="V") Type valueType) {
        this.keyType = Objects.requireNonNull(keyType);
        this.valueType = Objects.requireNonNull(valueType);
        this.arrayType = new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)valueType, (Object)keyType)));
    }

    public Type getSerializedType() {
        return this.arrayType;
    }

    public void serialize(MultimapAggregationState state, BlockBuilder out) {
        if (state.isEmpty()) {
            out.appendNull();
            return;
        }
        BlockBuilder entryBuilder = out.beginBlockEntry();
        state.forEach((keyBlock, valueBlock, position) -> {
            BlockBuilder rowBlockBuilder = entryBuilder.beginBlockEntry();
            this.valueType.appendTo(valueBlock, position, rowBlockBuilder);
            this.keyType.appendTo(keyBlock, position, rowBlockBuilder);
            entryBuilder.closeEntry();
        });
        out.closeEntry();
    }

    public void deserialize(Block block, int index, MultimapAggregationState state) {
        state.reset();
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)this.arrayType.getObject(block, index));
        Block keys = columnarRow.getField(1);
        Block values = columnarRow.getField(0);
        for (int i = 0; i < columnarRow.getPositionCount(); ++i) {
            state.add(keys, values, i);
        }
    }
}

