/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.ArrayAnyMatchFunction;
import io.trino.operator.scalar.BooleanToBooleanFunction;
import io.trino.operator.scalar.DoubleToBooleanFunction;
import io.trino.operator.scalar.LongToBooleanFunction;
import io.trino.operator.scalar.ObjectToBooleanFunction;
import io.trino.spi.block.Block;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameterSpecialization;
import io.trino.spi.type.Type;

@Description(value="Returns true if all elements of the array don't match the given predicate")
@ScalarFunction(value="none_match")
public final class ArrayNoneMatchFunction {
    private ArrayNoneMatchFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Object.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean noneMatchObject(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") ObjectToBooleanFunction function) {
        Boolean anyMatchResult = ArrayAnyMatchFunction.anyMatchObject(elementType, arrayBlock, function);
        if (anyMatchResult == null) {
            return null;
        }
        return anyMatchResult == false;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean noneMatchLong(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") LongToBooleanFunction function) {
        Boolean anyMatchResult = ArrayAnyMatchFunction.anyMatchLong(elementType, arrayBlock, function);
        if (anyMatchResult == null) {
            return null;
        }
        return anyMatchResult == false;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean noneMatchDouble(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") DoubleToBooleanFunction function) {
        Boolean anyMatchResult = ArrayAnyMatchFunction.anyMatchDouble(elementType, arrayBlock, function);
        if (anyMatchResult == null) {
            return null;
        }
        return anyMatchResult == false;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean noneMatchBoolean(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") BooleanToBooleanFunction function) {
        Boolean anyMatchResult = ArrayAnyMatchFunction.anyMatchBoolean(elementType, arrayBlock, function);
        if (anyMatchResult == null) {
            return null;
        }
        return anyMatchResult == false;
    }
}

