/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import java.util.List;

@ScalarFunction(value="reverse")
@Description(value="Returns an array which has the reversed order of the given array.")
public final class ArrayReverseFunction {
    private final PageBuilder pageBuilder;

    @TypeParameter(value="E")
    public ArrayReverseFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block reverse(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block block) {
        int arrayLength = block.getPositionCount();
        if (arrayLength < 2) {
            return block;
        }
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (int i = arrayLength - 1; i >= 0; --i) {
            type.appendTo(block, i, blockBuilder);
        }
        this.pageBuilder.declarePositions(arrayLength);
        return blockBuilder.getRegion(blockBuilder.getPositionCount() - arrayLength, arrayLength);
    }
}

