/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.function.Signature;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandle;
import java.util.Objects;

public class GenericEqualOperator
extends SqlScalarFunction {
    private final TypeOperators typeOperators;

    public GenericEqualOperator(TypeOperators typeOperators) {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().operatorType(OperatorType.EQUAL).comparableTypeParameter("T").returnType((Type)BooleanType.BOOLEAN).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).build()).nullable().build());
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        Type type = boundSignature.getArgumentType(0);
        return invocationConvention -> {
            MethodHandle methodHandle = this.typeOperators.getEqualOperator(type, invocationConvention);
            return ScalarFunctionImplementation.builder().methodHandle(methodHandle).build();
        };
    }
}

