/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;

@ScalarFunction(value="to_unixtime")
public final class ToUnixTime {
    private ToUnixTime() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="double")
    public static double toUnixTime(@SqlType(value="timestamp(p) with time zone") long timestamp) {
        return (double)DateTimeEncoding.unpackMillisUtc((long)timestamp) * 1.0 / 1000.0;
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="double")
    public static double toUnixTime(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return (double)timestamp.getEpochMillis() * 1.0 / 1000.0 + (double)timestamp.getPicosOfMilli() * 1.0 / 1.0E12;
    }
}

