/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.execution.QueryState;
import io.trino.server.BasicQueryInfo;
import io.trino.server.QueryProgressStats;
import io.trino.server.ResourceGroupInfo;
import io.trino.spi.QueryId;
import io.trino.spi.resourcegroups.ResourceGroupId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTime;

public class QueryStateInfo {
    private final QueryState queryState;
    private final QueryId queryId;
    private final Optional<ResourceGroupId> resourceGroupId;
    private final String query;
    private final DateTime createTime;
    private final String user;
    private final Optional<String> source;
    private final Optional<String> clientInfo;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final Optional<List<ResourceGroupInfo>> pathToRoot;
    private final Optional<QueryProgressStats> progress;

    @JsonCreator
    public QueryStateInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="queryState") QueryState queryState, @JsonProperty(value="resourceGroupId") Optional<ResourceGroupId> resourceGroupId, @JsonProperty(value="query") String query, @JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="user") String user, @JsonProperty(value="source") Optional<String> source, @JsonProperty(value="clientInfo") Optional<String> clientInfo, @JsonProperty(value="catalog") Optional<String> catalog, @JsonProperty(value="schema") Optional<String> schema, @JsonProperty(value="pathToRoot") Optional<List<ResourceGroupInfo>> pathToRoot, @JsonProperty(value="progress") Optional<QueryProgressStats> progress) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.queryState = Objects.requireNonNull(queryState, "queryState is null");
        this.resourceGroupId = Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        this.query = Objects.requireNonNull(query, "query text is null");
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.user = Objects.requireNonNull(user, "user is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(pathToRoot, "pathToRoot is null");
        this.pathToRoot = pathToRoot.map(ImmutableList::copyOf);
        this.progress = Objects.requireNonNull(progress, "progress is null");
    }

    public static QueryStateInfo createQueuedQueryStateInfo(BasicQueryInfo queryInfo, Optional<ResourceGroupId> group, Optional<List<ResourceGroupInfo>> pathToRoot) {
        return QueryStateInfo.createQueryStateInfo(queryInfo, group, pathToRoot, Optional.empty());
    }

    public static QueryStateInfo createQueryStateInfo(BasicQueryInfo queryInfo, Optional<ResourceGroupId> group) {
        Optional<QueryProgressStats> progress = Optional.empty();
        if (!queryInfo.getState().isDone() && queryInfo.getState() != QueryState.QUEUED) {
            progress = Optional.of(QueryProgressStats.createQueryProgressStats(queryInfo.getQueryStats()));
        }
        return QueryStateInfo.createQueryStateInfo(queryInfo, group, Optional.empty(), progress);
    }

    private static QueryStateInfo createQueryStateInfo(BasicQueryInfo queryInfo, Optional<ResourceGroupId> groupId, Optional<List<ResourceGroupInfo>> pathToRoot, Optional<QueryProgressStats> progress) {
        return new QueryStateInfo(queryInfo.getQueryId(), queryInfo.getState(), groupId, queryInfo.getQuery(), queryInfo.getQueryStats().getCreateTime(), queryInfo.getSession().getUser(), queryInfo.getSession().getSource(), queryInfo.getSession().getClientInfo(), queryInfo.getSession().getCatalog(), queryInfo.getSession().getSchema(), pathToRoot, progress);
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public QueryState getQueryState() {
        return this.queryState;
    }

    @JsonProperty
    public Optional<ResourceGroupId> getResourceGroupId() {
        return this.resourceGroupId;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public Optional<String> getSource() {
        return this.source;
    }

    @JsonProperty
    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    @JsonProperty
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public Optional<List<ResourceGroupInfo>> getPathToRoot() {
        return this.pathToRoot;
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @JsonProperty
    public Optional<QueryProgressStats> getProgress() {
        return this.progress;
    }
}

