/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.base.Verify;
import com.google.inject.Inject;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.Authenticator;
import io.trino.server.security.HeaderAuthenticatorConfig;
import io.trino.server.security.HeaderAuthenticatorManager;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import java.security.Principal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;

public class HeaderAuthenticator
implements Authenticator {
    private final HeaderAuthenticatorManager authenticatorManager;
    private final UserMapping userMapping;

    @Inject
    public HeaderAuthenticator(HeaderAuthenticatorConfig authenticatorConfig, HeaderAuthenticatorManager authenticatorManager) {
        this.authenticatorManager = Objects.requireNonNull(authenticatorManager, "authenticatorManager is null");
        this.userMapping = UserMapping.createUserMapping(authenticatorConfig.getUserMappingPattern(), authenticatorConfig.getUserMappingFile());
        this.authenticatorManager.setRequired();
    }

    @Override
    public Identity authenticate(ContainerRequestContext request) throws AuthenticationException {
        AuthenticationException exception = null;
        Map<String, List> lowerCasedHeaders = request.getHeaders().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(Locale.ENGLISH), Map.Entry::getValue));
        for (io.trino.spi.security.HeaderAuthenticator authenticator : this.authenticatorManager.getAuthenticators()) {
            try {
                Principal principal = authenticator.createAuthenticatedPrincipal(name -> (List)lowerCasedHeaders.get(name.toLowerCase(Locale.ENGLISH)));
                String authenticatedUser = this.userMapping.mapUser(principal.toString());
                return Identity.forUser((String)authenticatedUser).withPrincipal(principal).build();
            }
            catch (UserMappingException | AccessDeniedException e) {
                if (exception == null) {
                    exception = new AuthenticationException(e.getMessage());
                    continue;
                }
                exception.addSuppressed(new AuthenticationException(e.getMessage()));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Authentication error", e);
            }
        }
        Verify.verify((exception != null ? 1 : 0) != 0, (String)"exception is not set", (Object[])new Object[0]);
        throw exception;
    }
}

