/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import com.google.common.base.Preconditions;
import io.trino.operator.SpillContext;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LocalSpillContext
implements SpillContext {
    private final SpillContext parentSpillContext;
    private long spilledBytes;
    private boolean closed;

    public LocalSpillContext(SpillContext parentSpillContext) {
        this.parentSpillContext = parentSpillContext;
    }

    @Override
    public synchronized void updateBytes(long bytes) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Already closed");
        this.parentSpillContext.updateBytes(bytes);
        this.spilledBytes += bytes;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.parentSpillContext.updateBytes(-this.spilledBytes);
    }
}

