/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.connector.CatalogHandle;
import io.trino.metadata.Split;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.split.SplitSource;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class ConnectorAwareSplitSource
implements SplitSource {
    private final CatalogHandle catalogHandle;
    private final ConnectorSplitSource source;

    public ConnectorAwareSplitSource(CatalogHandle catalogHandle, ConnectorSplitSource source) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.source = Objects.requireNonNull(source, "source is null");
    }

    @Override
    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    @Override
    public ListenableFuture<SplitSource.SplitBatch> getNextBatch(int maxSize) {
        ListenableFuture nextBatch = MoreFutures.toListenableFuture((CompletableFuture)this.source.getNextBatch(maxSize));
        return Futures.transform((ListenableFuture)nextBatch, splitBatch -> {
            ImmutableList.Builder result = ImmutableList.builder();
            for (ConnectorSplit connectorSplit : splitBatch.getSplits()) {
                result.add((Object)new Split(this.catalogHandle, connectorSplit));
            }
            return new SplitSource.SplitBatch((List<Split>)result.build(), splitBatch.isNoMoreSplits());
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public boolean isFinished() {
        return this.source.isFinished();
    }

    @Override
    public Optional<List<Object>> getTableExecuteSplitsInfo() {
        return this.source.getTableExecuteSplitsInfo();
    }

    public String toString() {
        return this.catalogHandle + ":" + this.source;
    }
}

