/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.execution.ParameterExtractor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ParameterUtils {
    private ParameterUtils() {
    }

    public static Map<NodeRef<Parameter>, Expression> parameterExtractor(Statement statement, List<Expression> parameters) {
        List parametersList = (List)ParameterExtractor.getParameters(statement).stream().sorted(Comparator.comparing(parameter -> (NodeLocation)parameter.getLocation().get(), Comparator.comparing(NodeLocation::getLineNumber).thenComparing(NodeLocation::getColumnNumber))).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterator<Expression> iterator = parameters.iterator();
        for (Parameter parameter2 : parametersList) {
            builder.put((Object)NodeRef.of((Node)parameter2), (Object)iterator.next());
        }
        return builder.buildOrThrow();
    }
}

