/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.connector.CatalogServiceProvider;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.TableFunctionRegistry;
import io.trino.metadata.TableProceduresPropertyManager;
import io.trino.metadata.TableProceduresRegistry;
import io.trino.metadata.TablePropertyManager;
import io.trino.security.AccessControl;
import io.trino.spi.security.GroupProvider;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.CorrelationSupport;
import io.trino.sql.analyzer.StatementAnalyzer;
import io.trino.sql.parser.SqlParser;
import io.trino.transaction.NoOpTransactionManager;
import io.trino.transaction.TransactionManager;
import java.util.Objects;
import javax.inject.Inject;

public class StatementAnalyzerFactory {
    private final PlannerContext plannerContext;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final TransactionManager transactionManager;
    private final GroupProvider groupProvider;
    private final TableProceduresRegistry tableProceduresRegistry;
    private final TableFunctionRegistry tableFunctionRegistry;
    private final SessionPropertyManager sessionPropertyManager;
    private final TablePropertyManager tablePropertyManager;
    private final AnalyzePropertyManager analyzePropertyManager;
    private final TableProceduresPropertyManager tableProceduresPropertyManager;

    @Inject
    public StatementAnalyzerFactory(PlannerContext plannerContext, SqlParser sqlParser, AccessControl accessControl, TransactionManager transactionManager, GroupProvider groupProvider, TableProceduresRegistry tableProceduresRegistry, TableFunctionRegistry tableFunctionRegistry, SessionPropertyManager sessionPropertyManager, TablePropertyManager tablePropertyManager, AnalyzePropertyManager analyzePropertyManager, TableProceduresPropertyManager tableProceduresPropertyManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.tableProceduresRegistry = Objects.requireNonNull(tableProceduresRegistry, "tableProceduresRegistry is null");
        this.tableFunctionRegistry = Objects.requireNonNull(tableFunctionRegistry, "tableFunctionRegistry is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
        this.analyzePropertyManager = Objects.requireNonNull(analyzePropertyManager, "analyzePropertyManager is null");
        this.tableProceduresPropertyManager = Objects.requireNonNull(tableProceduresPropertyManager, "tableProceduresPropertyManager is null");
    }

    public StatementAnalyzerFactory withSpecializedAccessControl(AccessControl accessControl) {
        return new StatementAnalyzerFactory(this.plannerContext, this.sqlParser, accessControl, this.transactionManager, this.groupProvider, this.tableProceduresRegistry, this.tableFunctionRegistry, this.sessionPropertyManager, this.tablePropertyManager, this.analyzePropertyManager, this.tableProceduresPropertyManager);
    }

    public StatementAnalyzer createStatementAnalyzer(Analysis analysis, Session session, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        return new StatementAnalyzer(this, analysis, this.plannerContext, this.sqlParser, this.groupProvider, this.accessControl, this.transactionManager, session, this.tableProceduresRegistry, this.tableFunctionRegistry, this.sessionPropertyManager, this.tablePropertyManager, this.analyzePropertyManager, this.tableProceduresPropertyManager, warningCollector, correlationSupport);
    }

    public static StatementAnalyzerFactory createTestingStatementAnalyzerFactory(PlannerContext plannerContext, AccessControl accessControl, TablePropertyManager tablePropertyManager, AnalyzePropertyManager analyzePropertyManager) {
        return new StatementAnalyzerFactory(plannerContext, new SqlParser(), accessControl, new NoOpTransactionManager(), user -> ImmutableSet.of(), new TableProceduresRegistry(CatalogServiceProvider.fail("procedures are not supported in testing analyzer")), new TableFunctionRegistry(CatalogServiceProvider.fail("table functions are not supported in testing analyzer")), new SessionPropertyManager(), tablePropertyManager, analyzePropertyManager, new TableProceduresPropertyManager(CatalogServiceProvider.fail("procedures are not supported in testing analyzer")));
    }
}

