/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.util.CompilerUtils;
import io.trino.util.Failures;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class VarArgsToMapAdapterGenerator {
    private VarArgsToMapAdapterGenerator() {
    }

    public static MethodHandle generateVarArgsToMapAdapter(Class<?> returnType, List<Class<?>> javaTypes, List<String> names, Function<Map<String, Object>, Object> function) {
        Failures.checkCondition(javaTypes.size() <= 254, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for vararg function", new Object[0]);
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("VarArgsToMapAdapter"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        ImmutableList.Builder parameterListBuilder = ImmutableList.builder();
        for (int i = 0; i < javaTypes.size(); ++i) {
            Class<?> javaType = javaTypes.get(i);
            parameterListBuilder.add((Object)Parameter.arg((String)("input_" + i), javaType));
        }
        ImmutableList parameterList = parameterListBuilder.build();
        MethodDefinition methodDefinition = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "varArgsToMap", ParameterizedType.type(returnType), (Iterable)parameterList);
        BytecodeBlock body = methodDefinition.getBody();
        Variable map = methodDefinition.getScope().declareVariable("map", methodDefinition.getBody(), BytecodeExpressions.invokeStatic(Maps.class, (String)"newHashMapWithExpectedSize", HashMap.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantInt((int)javaTypes.size())}));
        for (int i = 0; i < javaTypes.size(); ++i) {
            body.append((BytecodeNode)map.invoke("put", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantString((String)names.get(i)).cast(Object.class), ((Parameter)parameterList.get(i)).cast(Object.class)}));
        }
        body.append((BytecodeNode)BytecodeUtils.loadConstant(callSiteBinder, function, Function.class).invoke("apply", Object.class, new BytecodeExpression[]{map.cast(Object.class)}).cast(returnType).ret());
        Class<Object> generatedClass = CompilerUtils.defineClass(classDefinition, Object.class, callSiteBinder.getBindings(), (ClassLoader)new DynamicClassLoader(VarArgsToMapAdapterGenerator.class.getClassLoader()));
        return Reflection.methodHandle(generatedClass, "varArgsToMap", javaTypes.toArray(new Class[javaTypes.size()]));
    }
}

