/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import io.trino.metadata.Metadata;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.ExpressionNodeInliner;
import io.trino.sql.planner.NullabilityAnalyzer;
import io.trino.sql.planner.SubExpressionExtractor;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import io.trino.util.DisjointSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EqualityInference {
    private static final Comparator<Expression> CANONICAL_COMPARATOR = Comparator.comparingInt(expression -> SymbolsExtractor.extractAll(expression).size()).thenComparingLong(expression -> SubExpressionExtractor.extract(expression).count()).thenComparing(Expression::toString);
    private final Multimap<Expression, Expression> equalitySets;
    private final Map<Expression, Expression> canonicalMap;
    private final Set<Expression> derivedExpressions;

    private EqualityInference(Multimap<Expression, Expression> equalitySets, Map<Expression, Expression> canonicalMap, Set<Expression> derivedExpressions) {
        this.equalitySets = equalitySets;
        this.canonicalMap = canonicalMap;
        this.derivedExpressions = derivedExpressions;
    }

    public Expression rewrite(Expression expression, Set<Symbol> scope) {
        return this.rewrite(expression, scope::contains, true);
    }

    public EqualityPartition generateEqualitiesPartitionedBy(Set<Symbol> scope) {
        ImmutableSet.Builder scopeEqualities = ImmutableSet.builder();
        ImmutableSet.Builder scopeComplementEqualities = ImmutableSet.builder();
        ImmutableSet.Builder scopeStraddlingEqualities = ImmutableSet.builder();
        for (Collection equalitySet : this.equalitySets.asMap().values()) {
            LinkedHashSet scopeExpressions = new LinkedHashSet();
            LinkedHashSet scopeComplementExpressions = new LinkedHashSet();
            LinkedHashSet scopeStraddlingExpressions = new LinkedHashSet();
            equalitySet.stream().filter(candidate -> !this.derivedExpressions.contains(candidate)).forEach(candidate -> {
                Expression scopeComplementRewritten;
                Expression scopeRewritten = this.rewrite((Expression)candidate, scope::contains, false);
                if (scopeRewritten != null) {
                    scopeExpressions.add(scopeRewritten);
                }
                if ((scopeComplementRewritten = this.rewrite((Expression)candidate, expression -> !scope.contains(expression), false)) != null) {
                    scopeComplementExpressions.add(scopeComplementRewritten);
                }
                if (scopeRewritten == null && scopeComplementRewritten == null) {
                    scopeStraddlingExpressions.add(candidate);
                }
            });
            Expression matchingCanonical = EqualityInference.getCanonical(scopeExpressions.stream());
            if (scopeExpressions.size() >= 2) {
                scopeExpressions.stream().filter(expression -> !expression.equals((Object)matchingCanonical)).map(expression -> new ComparisonExpression(ComparisonExpression.Operator.EQUAL, matchingCanonical, expression)).forEach(arg_0 -> ((ImmutableSet.Builder)scopeEqualities).add(arg_0));
            }
            Expression complementCanonical = EqualityInference.getCanonical(scopeComplementExpressions.stream());
            if (scopeComplementExpressions.size() >= 2) {
                scopeComplementExpressions.stream().filter(expression -> !expression.equals((Object)complementCanonical)).map(expression -> new ComparisonExpression(ComparisonExpression.Operator.EQUAL, complementCanonical, expression)).forEach(arg_0 -> ((ImmutableSet.Builder)scopeComplementEqualities).add(arg_0));
            }
            List<Object> connectingExpressions = new ArrayList<Object>();
            connectingExpressions.add(matchingCanonical);
            connectingExpressions.add(complementCanonical);
            connectingExpressions.addAll(scopeStraddlingExpressions);
            Expression connectingCanonical = EqualityInference.getCanonical((connectingExpressions = connectingExpressions.stream().filter(Objects::nonNull).collect(Collectors.toList())).stream());
            if (connectingCanonical == null) continue;
            connectingExpressions.stream().filter(expression -> !expression.equals((Object)connectingCanonical)).map(expression -> new ComparisonExpression(ComparisonExpression.Operator.EQUAL, connectingCanonical, expression)).forEach(arg_0 -> ((ImmutableSet.Builder)scopeStraddlingEqualities).add(arg_0));
        }
        return new EqualityPartition((Iterable<Expression>)scopeEqualities.build(), (Iterable<Expression>)scopeComplementEqualities.build(), (Iterable<Expression>)scopeStraddlingEqualities.build());
    }

    public static boolean isInferenceCandidate(Metadata metadata, Expression expression) {
        ComparisonExpression comparison;
        if (expression instanceof ComparisonExpression && DeterminismEvaluator.isDeterministic(expression, metadata) && !NullabilityAnalyzer.mayReturnNullOnNonNullInput(expression) && (comparison = (ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL) {
            return !comparison.getLeft().equals((Object)comparison.getRight());
        }
        return false;
    }

    public static EqualityInference newInstance(Metadata metadata, Expression ... expressions) {
        return EqualityInference.newInstance(metadata, Arrays.asList(expressions));
    }

    public static EqualityInference newInstance(Metadata metadata, Collection<Expression> expressions) {
        DisjointSet<Expression> equalities = new DisjointSet<Expression>();
        expressions.stream().flatMap(expression -> ExpressionUtils.extractConjuncts(expression).stream()).filter(expression -> EqualityInference.isInferenceCandidate(metadata, expression)).forEach(expression -> {
            ComparisonExpression comparison = (ComparisonExpression)expression;
            Expression expression1 = comparison.getLeft();
            Expression expression2 = comparison.getRight();
            equalities.findAndUnion(expression1, expression2);
        });
        Collection equivalentClasses = equalities.getEquivalentClasses();
        HashMap byExpression = new HashMap();
        for (Set<Expression> set : equivalentClasses) {
            set.forEach(expression -> byExpression.put(expression, equivalence));
        }
        LinkedHashSet<Expression> derivedExpressions = new LinkedHashSet<Expression>();
        for (Expression expression2 : byExpression.keySet()) {
            if (derivedExpressions.contains(expression2)) continue;
            SubExpressionExtractor.extract(expression2).filter(e -> !e.equals((Object)expression2)).forEach(subExpression -> ((Set)byExpression.getOrDefault(subExpression, ImmutableSet.of())).stream().filter(e -> !e.equals(subExpression)).forEach(equivalentSubExpression -> {
                Expression rewritten = ExpressionNodeInliner.replaceExpression(expression2, (Map<? extends Expression, ? extends Expression>)ImmutableMap.of((Object)subExpression, (Object)equivalentSubExpression));
                equalities.findAndUnion(expression2, rewritten);
                derivedExpressions.add(rewritten);
            }));
        }
        Multimap<Expression, Expression> multimap = EqualityInference.makeEqualitySets(equalities);
        ImmutableMap.Builder canonicalMappings = ImmutableMap.builder();
        for (Map.Entry entry : multimap.entries()) {
            Expression canonical = (Expression)entry.getKey();
            Expression expression3 = (Expression)entry.getValue();
            canonicalMappings.put((Object)expression3, (Object)canonical);
        }
        return new EqualityInference(multimap, (Map<Expression, Expression>)canonicalMappings.buildOrThrow(), derivedExpressions);
    }

    public static Stream<Expression> nonInferrableConjuncts(Metadata metadata, Expression expression) {
        return ExpressionUtils.extractConjuncts(expression).stream().filter(e -> !EqualityInference.isInferenceCandidate(metadata, e));
    }

    private Expression rewrite(Expression expression, Predicate<Symbol> symbolScope, boolean allowFullReplacement) {
        HashMap expressionRemap = new HashMap();
        SubExpressionExtractor.extract(expression).filter(allowFullReplacement ? subExpression -> true : subExpression -> !subExpression.equals((Object)expression)).forEach(subExpression -> {
            Expression canonical = this.getScopedCanonical((Expression)subExpression, symbolScope);
            if (canonical != null) {
                expressionRemap.putIfAbsent(subExpression, canonical);
            }
        });
        Expression rewritten = ExpressionNodeInliner.replaceExpression(expression, expressionRemap);
        if (!EqualityInference.isScoped(rewritten, symbolScope)) {
            return null;
        }
        return rewritten;
    }

    private static Expression getCanonical(Stream<Expression> expressions) {
        return expressions.min(CANONICAL_COMPARATOR).orElse(null);
    }

    @VisibleForTesting
    Expression getScopedCanonical(Expression expression, Predicate<Symbol> symbolScope) {
        Expression canonicalIndex = this.canonicalMap.get(expression);
        if (canonicalIndex == null) {
            return null;
        }
        Collection equivalences = this.equalitySets.get((Object)canonicalIndex);
        if (expression instanceof SymbolReference) {
            boolean inScope = equivalences.stream().filter(SymbolReference.class::isInstance).map(Symbol::from).anyMatch(symbolScope);
            if (!inScope) {
                return null;
            }
        }
        return EqualityInference.getCanonical(equivalences.stream().filter(e -> EqualityInference.isScoped(e, symbolScope)));
    }

    private static boolean isScoped(Expression expression, Predicate<Symbol> symbolScope) {
        return SymbolsExtractor.extractUnique(expression).stream().allMatch(symbolScope);
    }

    private static Multimap<Expression, Expression> makeEqualitySets(DisjointSet<Expression> equalities) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Set<Expression> equalityGroup : equalities.getEquivalentClasses()) {
            if (equalityGroup.isEmpty()) continue;
            builder.putAll((Object)equalityGroup.stream().min(CANONICAL_COMPARATOR).get(), equalityGroup);
        }
        return builder.build();
    }

    public static class EqualityPartition {
        private final List<Expression> scopeEqualities;
        private final List<Expression> scopeComplementEqualities;
        private final List<Expression> scopeStraddlingEqualities;

        public EqualityPartition(Iterable<Expression> scopeEqualities, Iterable<Expression> scopeComplementEqualities, Iterable<Expression> scopeStraddlingEqualities) {
            this.scopeEqualities = ImmutableList.copyOf(Objects.requireNonNull(scopeEqualities, "scopeEqualities is null"));
            this.scopeComplementEqualities = ImmutableList.copyOf(Objects.requireNonNull(scopeComplementEqualities, "scopeComplementEqualities is null"));
            this.scopeStraddlingEqualities = ImmutableList.copyOf(Objects.requireNonNull(scopeStraddlingEqualities, "scopeStraddlingEqualities is null"));
        }

        public List<Expression> getScopeEqualities() {
            return this.scopeEqualities;
        }

        public List<Expression> getScopeComplementEqualities() {
            return this.scopeComplementEqualities;
        }

        public List<Expression> getScopeStraddlingEqualities() {
            return this.scopeStraddlingEqualities;
        }
    }
}

