/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.predicate.NullableValue;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.Symbol;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Partitioning {
    private final PartitioningHandle handle;
    private final List<ArgumentBinding> arguments;

    private Partitioning(PartitioningHandle handle, List<ArgumentBinding> arguments) {
        this.handle = Objects.requireNonNull(handle, "handle is null");
        this.arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
    }

    public static Partitioning create(PartitioningHandle handle, List<Symbol> columns) {
        return new Partitioning(handle, (List)columns.stream().map(Symbol::toSymbolReference).map(ArgumentBinding::expressionBinding).collect(ImmutableList.toImmutableList()));
    }

    @JsonCreator
    public static Partitioning jsonCreate(@JsonProperty(value="handle") PartitioningHandle handle, @JsonProperty(value="arguments") List<ArgumentBinding> arguments) {
        return new Partitioning(handle, arguments);
    }

    @JsonProperty
    public PartitioningHandle getHandle() {
        return this.handle;
    }

    @JsonProperty
    public List<ArgumentBinding> getArguments() {
        return this.arguments;
    }

    public Set<Symbol> getColumns() {
        return (Set)this.arguments.stream().filter(ArgumentBinding::isVariable).map(ArgumentBinding::getColumn).collect(ImmutableSet.toImmutableSet());
    }

    public boolean isCompatibleWith(Partitioning right, Metadata metadata, Session session) {
        if (!this.handle.equals(right.handle) && metadata.getCommonPartitioning(session, this.handle, right.handle).isEmpty()) {
            return false;
        }
        return this.arguments.equals(right.arguments);
    }

    public boolean isCompatibleWith(Partitioning right, Function<Symbol, Set<Symbol>> leftToRightMappings, Function<Symbol, Optional<NullableValue>> leftConstantMapping, Function<Symbol, Optional<NullableValue>> rightConstantMapping, Metadata metadata, Session session) {
        if (!this.handle.equals(right.handle) && metadata.getCommonPartitioning(session, this.handle, right.handle).isEmpty()) {
            return false;
        }
        if (this.arguments.size() != right.arguments.size()) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            ArgumentBinding rightArgument;
            ArgumentBinding leftArgument = this.arguments.get(i);
            if (Partitioning.isPartitionedWith(leftArgument, leftConstantMapping, rightArgument = right.arguments.get(i), rightConstantMapping, leftToRightMappings)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPartitionedWith(ArgumentBinding leftArgument, Function<Symbol, Optional<NullableValue>> leftConstantMapping, ArgumentBinding rightArgument, Function<Symbol, Optional<NullableValue>> rightConstantMapping, Function<Symbol, Set<Symbol>> leftToRightMappings) {
        if (leftArgument.isVariable()) {
            if (rightArgument.isVariable()) {
                Set<Symbol> mappedColumns = leftToRightMappings.apply(leftArgument.getColumn());
                return mappedColumns.contains(rightArgument.getColumn());
            }
            Optional<NullableValue> leftConstant = leftConstantMapping.apply(leftArgument.getColumn());
            return leftConstant.isPresent() && leftConstant.get().equals((Object)rightArgument.getConstant());
        }
        if (rightArgument.isConstant()) {
            return leftArgument.getConstant().equals((Object)rightArgument.getConstant());
        }
        Optional<NullableValue> rightConstant = rightConstantMapping.apply(rightArgument.getColumn());
        return rightConstant.isPresent() && rightConstant.get().equals((Object)leftArgument.getConstant());
    }

    public boolean isPartitionedOn(Collection<Symbol> columns, Set<Symbol> knownConstants) {
        for (ArgumentBinding argument : this.arguments) {
            if (argument.isConstant()) continue;
            if (!argument.isVariable()) {
                return false;
            }
            if (knownConstants.contains(argument.getColumn()) || columns.contains(argument.getColumn())) continue;
            return false;
        }
        return true;
    }

    public boolean isPartitionedOnExactly(Collection<Symbol> columns, Set<Symbol> knownConstants) {
        HashSet<Symbol> toCheck = new HashSet<Symbol>();
        for (ArgumentBinding argument : this.arguments) {
            if (argument.isConstant()) continue;
            if (!argument.isVariable()) {
                return false;
            }
            if (knownConstants.contains(argument.getColumn())) continue;
            toCheck.add(argument.getColumn());
        }
        return ImmutableSet.copyOf(columns).equals(toCheck);
    }

    public boolean isEffectivelySinglePartition(Set<Symbol> knownConstants) {
        return this.isPartitionedOn((Collection<Symbol>)ImmutableSet.of(), knownConstants);
    }

    public boolean isRepartitionEffective(Collection<Symbol> keys, Set<Symbol> knownConstants) {
        Set keysWithoutConstants = (Set)keys.stream().filter(symbol -> !knownConstants.contains(symbol)).collect(ImmutableSet.toImmutableSet());
        Set nonConstantArgs = (Set)this.arguments.stream().filter(ArgumentBinding::isVariable).map(ArgumentBinding::getColumn).filter(symbol -> !knownConstants.contains(symbol)).collect(ImmutableSet.toImmutableSet());
        return !nonConstantArgs.equals(keysWithoutConstants);
    }

    public Partitioning translate(Function<Symbol, Symbol> translator) {
        return new Partitioning(this.handle, (List)this.arguments.stream().map(argument -> argument.translate(translator)).collect(ImmutableList.toImmutableList()));
    }

    public Optional<Partitioning> translate(Translator translator) {
        ImmutableList.Builder newArguments = ImmutableList.builder();
        for (ArgumentBinding argument : this.arguments) {
            Optional<ArgumentBinding> newArgument = argument.translate(translator);
            if (newArgument.isEmpty()) {
                return Optional.empty();
            }
            newArguments.add((Object)newArgument.get());
        }
        return Optional.of(new Partitioning(this.handle, (List<ArgumentBinding>)newArguments.build()));
    }

    public Partitioning withAlternativePartitioningHandle(PartitioningHandle partitioningHandle) {
        return new Partitioning(partitioningHandle, this.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.handle, this.arguments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Partitioning other = (Partitioning)obj;
        return Objects.equals(this.handle, other.handle) && Objects.equals(this.arguments, other.arguments);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("handle", (Object)this.handle).add("arguments", this.arguments).toString();
    }

    @Immutable
    public static final class ArgumentBinding {
        private final Expression expression;
        private final NullableValue constant;

        @JsonCreator
        public ArgumentBinding(@JsonProperty(value="expression") Expression expression, @JsonProperty(value="constant") NullableValue constant) {
            this.expression = expression;
            this.constant = constant;
            Preconditions.checkArgument((expression == null != (constant == null) ? 1 : 0) != 0, (Object)"Either expression or constant must be set");
        }

        public static ArgumentBinding expressionBinding(Expression expression) {
            return new ArgumentBinding(Objects.requireNonNull(expression, "expression is null"), null);
        }

        public static ArgumentBinding constantBinding(NullableValue constant) {
            return new ArgumentBinding(null, Objects.requireNonNull(constant, "constant is null"));
        }

        public boolean isConstant() {
            return this.constant != null;
        }

        public boolean isVariable() {
            return this.expression instanceof SymbolReference;
        }

        public Symbol getColumn() {
            Verify.verify((boolean)(this.expression instanceof SymbolReference), (String)"Expect the expression to be a SymbolReference", (Object[])new Object[0]);
            return Symbol.from(this.expression);
        }

        @JsonProperty
        public Expression getExpression() {
            return this.expression;
        }

        @JsonProperty
        public NullableValue getConstant() {
            return this.constant;
        }

        public ArgumentBinding translate(Function<Symbol, Symbol> translator) {
            if (this.isConstant()) {
                return this;
            }
            return ArgumentBinding.expressionBinding((Expression)translator.apply(Symbol.from(this.expression)).toSymbolReference());
        }

        public Optional<ArgumentBinding> translate(Translator translator) {
            if (this.isConstant()) {
                return Optional.of(this);
            }
            if (!this.isVariable()) {
                return translator.expressionTranslator.apply(this.expression).map(Symbol::toSymbolReference).map(ArgumentBinding::expressionBinding);
            }
            Optional<ArgumentBinding> newColumn = translator.columnTranslator.apply(Symbol.from(this.expression)).map(Symbol::toSymbolReference).map(ArgumentBinding::expressionBinding);
            if (newColumn.isPresent()) {
                return newColumn;
            }
            return translator.constantTranslator.apply(Symbol.from(this.expression)).map(ArgumentBinding::constantBinding);
        }

        public String toString() {
            if (this.constant != null) {
                return this.constant.toString();
            }
            return this.expression.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArgumentBinding that = (ArgumentBinding)o;
            return Objects.equals(this.expression, that.expression) && Objects.equals(this.constant, that.constant);
        }

        public int hashCode() {
            return Objects.hash(this.expression, this.constant);
        }
    }

    @Immutable
    public static final class Translator {
        private final Function<Symbol, Optional<Symbol>> columnTranslator;
        private final Function<Symbol, Optional<NullableValue>> constantTranslator;
        private final Function<Expression, Optional<Symbol>> expressionTranslator;

        public Translator(Function<Symbol, Optional<Symbol>> columnTranslator, Function<Symbol, Optional<NullableValue>> constantTranslator, Function<Expression, Optional<Symbol>> expressionTranslator) {
            this.columnTranslator = Objects.requireNonNull(columnTranslator, "columnTranslator is null");
            this.constantTranslator = Objects.requireNonNull(constantTranslator, "constantTranslator is null");
            this.expressionTranslator = Objects.requireNonNull(expressionTranslator, "expressionTranslator is null");
        }
    }
}

