/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import java.util.Objects;

public class Symbol
implements Comparable<Symbol> {
    private final String name;

    public static Symbol from(Expression expression) {
        Preconditions.checkArgument((boolean)(expression instanceof SymbolReference), (String)"Unexpected expression: %s", (Object)expression);
        return new Symbol(((SymbolReference)expression).getName());
    }

    @JsonCreator
    public Symbol(String name) {
        Objects.requireNonNull(name, "name is null");
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public SymbolReference toSymbolReference() {
        return new SymbolReference(this.name);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return this.name.equals(symbol.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Symbol o) {
        return this.name.compareTo(o.name);
    }
}

