/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.DateType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.WhenClause;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class CanonicalizeExpressionRewriter {
    public static Expression canonicalizeExpression(Expression expression, Map<NodeRef<Expression>, Type> expressionTypes, PlannerContext plannerContext, Session session) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(session, plannerContext, expressionTypes), (Expression)expression);
    }

    private CanonicalizeExpressionRewriter() {
    }

    public static Expression rewrite(Expression expression, Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, types, expression);
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(session, plannerContext, expressionTypes), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Session session;
        private final PlannerContext plannerContext;
        private final Metadata metadata;
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Session session, PlannerContext plannerContext, Map<NodeRef<Expression>, Type> expressionTypes) {
            this.session = session;
            this.plannerContext = plannerContext;
            this.metadata = plannerContext.getMetadata();
            this.expressionTypes = expressionTypes;
        }

        public Expression rewriteComparisonExpression(ComparisonExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (this.isConstant(node.getLeft()) && !this.isConstant(node.getRight())) {
                node = new ComparisonExpression(node.getOperator().flip(), node.getRight(), node.getLeft());
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }

        public Expression rewriteArithmeticBinary(ArithmeticBinaryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if ((node.getOperator() == ArithmeticBinaryExpression.Operator.MULTIPLY || node.getOperator() == ArithmeticBinaryExpression.Operator.ADD) && this.isConstant(node.getLeft()) && !this.isConstant(node.getRight())) {
                node = new ArithmeticBinaryExpression(node.getOperator(), node.getRight(), node.getLeft());
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }

        public Expression rewriteIsNotNullPredicate(IsNotNullPredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
            return new NotExpression((Expression)new IsNullPredicate(value));
        }

        public Expression rewriteIfExpression(IfExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression condition = treeRewriter.rewrite(node.getCondition(), (Object)context);
            Expression trueValue = treeRewriter.rewrite(node.getTrueValue(), (Object)context);
            Optional<Expression> falseValue = node.getFalseValue().map(value -> treeRewriter.rewrite(value, (Object)context));
            return new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause(condition, trueValue)), falseValue);
        }

        public Expression rewriteCurrentTime(CurrentTime node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            return switch (node.getFunction()) {
                default -> throw new IncompatibleClassChangeError();
                case CurrentTime.Function.DATE -> {
                    Preconditions.checkArgument((node.getPrecision() == null ? 1 : 0) != 0);
                    yield FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"current_date")).build();
                }
                case CurrentTime.Function.TIME -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"$current_time")).setArguments((List<Type>)ImmutableList.of((Object)this.expressionTypes.get(NodeRef.of((Node)node))), (List<Expression>)ImmutableList.of((Object)new NullLiteral())).build();
                case CurrentTime.Function.LOCALTIME -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"$localtime")).setArguments((List<Type>)ImmutableList.of((Object)this.expressionTypes.get(NodeRef.of((Node)node))), (List<Expression>)ImmutableList.of((Object)new NullLiteral())).build();
                case CurrentTime.Function.TIMESTAMP -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"$current_timestamp")).setArguments((List<Type>)ImmutableList.of((Object)this.expressionTypes.get(NodeRef.of((Node)node))), (List<Expression>)ImmutableList.of((Object)new NullLiteral())).build();
                case CurrentTime.Function.LOCALTIMESTAMP -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"$localtimestamp")).setArguments((List<Type>)ImmutableList.of((Object)this.expressionTypes.get(NodeRef.of((Node)node))), (List<Expression>)ImmutableList.of((Object)new NullLiteral())).build();
            };
        }

        public Expression rewriteExtract(Extract node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getExpression(), (Object)context);
            Type type = this.expressionTypes.get(NodeRef.of((Node)node.getExpression()));
            return switch (node.getField()) {
                default -> throw new IncompatibleClassChangeError();
                case Extract.Field.YEAR -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"year")).addArgument(type, value).build();
                case Extract.Field.QUARTER -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"quarter")).addArgument(type, value).build();
                case Extract.Field.MONTH -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"month")).addArgument(type, value).build();
                case Extract.Field.WEEK -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"week")).addArgument(type, value).build();
                case Extract.Field.DAY, Extract.Field.DAY_OF_MONTH -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"day")).addArgument(type, value).build();
                case Extract.Field.DAY_OF_WEEK, Extract.Field.DOW -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"day_of_week")).addArgument(type, value).build();
                case Extract.Field.DAY_OF_YEAR, Extract.Field.DOY -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"day_of_year")).addArgument(type, value).build();
                case Extract.Field.YEAR_OF_WEEK, Extract.Field.YOW -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"year_of_week")).addArgument(type, value).build();
                case Extract.Field.HOUR -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"hour")).addArgument(type, value).build();
                case Extract.Field.MINUTE -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"minute")).addArgument(type, value).build();
                case Extract.Field.SECOND -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"second")).addArgument(type, value).build();
                case Extract.Field.TIMEZONE_MINUTE -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"timezone_minute")).addArgument(type, value).build();
                case Extract.Field.TIMEZONE_HOUR -> FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"timezone_hour")).addArgument(type, value).build();
            };
        }

        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression argument;
            Type argumentType;
            String functionName = ResolvedFunction.extractFunctionName(node.getName());
            if (functionName.equals("date") && node.getArguments().size() == 1 && ((argumentType = this.expressionTypes.get(NodeRef.of((Node)(argument = (Expression)node.getArguments().get(0))))) instanceof TimestampType || argumentType instanceof TimestampWithTimeZoneType || argumentType instanceof VarcharType)) {
                return new Cast(treeRewriter.rewrite(argument, (Object)context), TypeSignatureTranslator.toSqlType((Type)DateType.DATE));
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }

        public Expression rewriteFormat(Format node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List arguments = (List)node.getArguments().stream().map(value -> treeRewriter.rewrite(value, (Object)context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)node.getArguments().stream().map(NodeRef::of).map(this.expressionTypes::get).collect(ImmutableList.toImmutableList());
            return FunctionCallBuilder.resolve(this.session, this.metadata).setName(QualifiedName.of((String)"$format")).addArgument((Type)VarcharType.VARCHAR, (Expression)arguments.get(0)).addArgument((Type)RowType.anonymous(argumentTypes.subList(1, arguments.size())), (Expression)new Row(arguments.subList(1, arguments.size()))).build();
        }

        private boolean isConstant(Expression expression) {
            return ExpressionUtils.isEffectivelyLiteral(this.plannerContext, this.session, expression);
        }
    }
}

