/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Patterns;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PruneOrderByInAggregation
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();
    private final Metadata metadata;

    public PruneOrderByInAggregation(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        if (!node.hasOrderings()) {
            return Rule.Result.empty();
        }
        boolean anyRewritten = false;
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            AggregationNode.Aggregation aggregation = entry.getValue();
            if (aggregation.getOrderingScheme().isEmpty()) {
                aggregations.put(entry);
                continue;
            }
            if (this.metadata.getAggregationFunctionMetadata(context.getSession(), aggregation.getResolvedFunction()).isOrderSensitive()) {
                aggregations.put(entry);
                continue;
            }
            anyRewritten = true;
            aggregations.put((Object)entry.getKey(), (Object)new AggregationNode.Aggregation(aggregation.getResolvedFunction(), aggregation.getArguments(), aggregation.isDistinct(), aggregation.getFilter(), Optional.empty(), aggregation.getMask()));
        }
        if (!anyRewritten) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(AggregationNode.builderFrom(node).setAggregations((Map<Symbol, AggregationNode.Aggregation>)aggregations.buildOrThrow()).build());
    }
}

