/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.TableExecuteNode;
import java.util.Set;

public class PruneTableExecuteSourceColumns
implements Rule<TableExecuteNode> {
    private static final Pattern<TableExecuteNode> PATTERN = Patterns.tableExecute();

    @Override
    public Pattern<TableExecuteNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableExecuteNode tableExecuteNode, Captures captures, Rule.Context context) {
        ImmutableSet.Builder requiredInputs = ImmutableSet.builder().addAll(tableExecuteNode.getColumns());
        if (tableExecuteNode.getPartitioningScheme().isPresent()) {
            PartitioningScheme partitioningScheme = tableExecuteNode.getPartitioningScheme().get();
            partitioningScheme.getPartitioning().getColumns().forEach(arg_0 -> ((ImmutableSet.Builder)requiredInputs).add(arg_0));
            partitioningScheme.getHashColumn().ifPresent(arg_0 -> ((ImmutableSet.Builder)requiredInputs).add(arg_0));
        }
        return Util.restrictChildOutputs(context.getIdAllocator(), tableExecuteNode, new Set[]{requiredInputs.build()}).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

