/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.type.Type;
import io.trino.sql.planner.ExpressionSymbolInliner;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PushProjectionThroughExchange
implements Rule<ProjectNode> {
    private static final Capture<ExchangeNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().matching(project -> !PushProjectionThroughExchange.isSymbolToSymbolProjection(project)).with(Patterns.source().matching(Patterns.exchange().capturedAs(CHILD)));

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode project, Captures captures, Rule.Context context) {
        ExchangeNode exchange = (ExchangeNode)captures.get(CHILD);
        Set<Symbol> partitioningColumns = exchange.getPartitioningScheme().getPartitioning().getColumns();
        ImmutableList.Builder newSourceBuilder = ImmutableList.builder();
        ImmutableList.Builder inputsBuilder = ImmutableList.builder();
        for (int i = 0; i < exchange.getSources().size(); ++i) {
            Map<Symbol, Symbol> outputToInputMap = PushProjectionThroughExchange.mapExchangeOutputToInput(exchange, i);
            Assignments.Builder projections = Assignments.builder();
            ImmutableList.Builder builder = ImmutableList.builder();
            partitioningColumns.stream().map(outputToInputMap::get).forEach(inputSymbol -> {
                projections.put((Symbol)inputSymbol, (Expression)inputSymbol.toSymbolReference());
                inputs.add(inputSymbol);
            });
            exchange.getPartitioningScheme().getHashColumn().map(outputToInputMap::get).ifPresent(inputSymbol -> {
                projections.put((Symbol)inputSymbol, (Expression)inputSymbol.toSymbolReference());
                inputs.add(inputSymbol);
            });
            if (exchange.getOrderingScheme().isPresent()) {
                exchange.getOrderingScheme().get().getOrderBy().stream().filter(symbol -> !partitioningColumns.contains(symbol)).map(outputToInputMap::get).forEach(inputSymbol -> {
                    projections.put((Symbol)inputSymbol, (Expression)inputSymbol.toSymbolReference());
                    inputs.add(inputSymbol);
                });
            }
            ImmutableSet.Builder outputBuilder = ImmutableSet.builder();
            partitioningColumns.forEach(arg_0 -> ((ImmutableSet.Builder)outputBuilder).add(arg_0));
            exchange.getPartitioningScheme().getHashColumn().ifPresent(arg_0 -> ((ImmutableSet.Builder)outputBuilder).add(arg_0));
            exchange.getOrderingScheme().ifPresent(orderingScheme -> outputBuilder.addAll(orderingScheme.getOrderBy()));
            ImmutableSet partitioningHashAndOrderingOutputs = outputBuilder.build();
            Map<Symbol, Expression> translationMap = outputToInputMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
            for (Map.Entry<Symbol, Expression> projection : project.getAssignments().entrySet()) {
                if (partitioningHashAndOrderingOutputs.contains(projection.getKey())) continue;
                Expression translatedExpression = ExpressionSymbolInliner.inlineSymbols(translationMap, projection.getValue());
                Type type = context.getSymbolAllocator().getTypes().get(projection.getKey());
                Symbol symbol2 = context.getSymbolAllocator().newSymbol(translatedExpression, type);
                projections.put(symbol2, translatedExpression);
                builder.add((Object)symbol2);
            }
            newSourceBuilder.add((Object)new ProjectNode(context.getIdAllocator().getNextId(), exchange.getSources().get(i), projections.build()));
            inputsBuilder.add((Object)builder.build());
        }
        ImmutableList.Builder outputBuilder = ImmutableList.builder();
        partitioningColumns.forEach(arg_0 -> ((ImmutableList.Builder)outputBuilder).add(arg_0));
        exchange.getPartitioningScheme().getHashColumn().ifPresent(arg_0 -> ((ImmutableList.Builder)outputBuilder).add(arg_0));
        if (exchange.getOrderingScheme().isPresent()) {
            exchange.getOrderingScheme().get().getOrderBy().stream().filter(symbol -> !partitioningColumns.contains(symbol)).forEach(arg_0 -> ((ImmutableList.Builder)outputBuilder).add(arg_0));
        }
        ImmutableSet partitioningHashAndOrderingOutputs = ImmutableSet.copyOf((Collection)outputBuilder.build());
        for (Map.Entry entry2 : project.getAssignments().entrySet()) {
            if (partitioningHashAndOrderingOutputs.contains(entry2.getKey())) continue;
            outputBuilder.add((Object)((Symbol)entry2.getKey()));
        }
        PartitioningScheme partitioningScheme = new PartitioningScheme(exchange.getPartitioningScheme().getPartitioning(), (List<Symbol>)outputBuilder.build(), exchange.getPartitioningScheme().getHashColumn(), exchange.getPartitioningScheme().isReplicateNullsAndAny(), exchange.getPartitioningScheme().getBucketToPartition());
        ExchangeNode exchangeNode = new ExchangeNode(exchange.getId(), exchange.getType(), exchange.getScope(), partitioningScheme, (List<PlanNode>)newSourceBuilder.build(), (List<List<Symbol>>)inputsBuilder.build(), exchange.getOrderingScheme());
        return Rule.Result.ofPlanNode(Util.restrictOutputs(context.getIdAllocator(), exchangeNode, (Set<Symbol>)ImmutableSet.copyOf(project.getOutputSymbols())).orElse(exchangeNode));
    }

    private static boolean isSymbolToSymbolProjection(ProjectNode project) {
        return project.getAssignments().getExpressions().stream().allMatch(SymbolReference.class::isInstance);
    }

    private static Map<Symbol, Symbol> mapExchangeOutputToInput(ExchangeNode exchange, int sourceIndex) {
        ImmutableMap.Builder outputToInputMap = ImmutableMap.builder();
        for (int i = 0; i < exchange.getOutputSymbols().size(); ++i) {
            outputToInputMap.put((Object)exchange.getOutputSymbols().get(i), (Object)exchange.getInputs().get(sourceIndex).get(i));
        }
        return outputToInputMap.buildOrThrow();
    }
}

