/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.TableStatsProvider;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.DeleteNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SimplePlanRewriter;
import java.util.List;
import java.util.Objects;

public class ReplicateJoinAndSemiJoinInDelete
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector, TableStatsProvider tableStatsProvider) {
        Objects.requireNonNull(plan, "plan is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private boolean isDeleteQuery;

        private Rewriter() {
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode leftSourceRewritten = context.rewrite(node.getLeft(), context.get());
            JoinNode rewrittenNode = (JoinNode)node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)leftSourceRewritten, (Object)node.getRight()));
            JoinNode.Type joinType = rewrittenNode.getType();
            if (this.isDeleteQuery && (joinType == JoinNode.Type.INNER || joinType == JoinNode.Type.LEFT)) {
                return rewrittenNode.withDistributionType(JoinNode.DistributionType.REPLICATED);
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode sourceRewritten = context.rewrite(node.getSource(), context.get());
            PlanNode filteringSourceRewritten = context.rewrite(node.getFilteringSource(), context.get());
            SemiJoinNode rewrittenNode = (SemiJoinNode)node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)sourceRewritten, (Object)filteringSourceRewritten));
            if (this.isDeleteQuery) {
                return rewrittenNode.withDistributionType(SemiJoinNode.DistributionType.REPLICATED);
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            this.isDeleteQuery = true;
            PlanNode rewrittenSource = context.rewrite(node.getSource());
            return node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenSource));
        }
    }
}

