/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import io.trino.Session;
import io.trino.execution.TableInfo;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableProperties;
import io.trino.metadata.TableSchema;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class TableInfoSupplier
implements Function<TableScanNode, TableInfo> {
    private final Metadata metadata;
    private final Session session;

    public TableInfoSupplier(Metadata metadata, Session session) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @Override
    public TableInfo apply(TableScanNode node) {
        TableSchema tableSchema = this.metadata.getTableSchema(this.session, node.getTable());
        TableProperties tableProperties = this.metadata.getTableProperties(this.session, node.getTable());
        Optional<String> connectorName = this.metadata.listCatalogs(this.session).stream().filter(catalogInfo -> catalogInfo.getCatalogName().equals(tableSchema.getCatalogName())).map(CatalogInfo::getConnectorName).findFirst();
        return new TableInfo(connectorName, tableSchema.getQualifiedName(), tableProperties.getPredicate());
    }
}

