/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.SimplePlanVisitor;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import io.trino.type.FunctionType;
import io.trino.type.TypeCoercion;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TypeValidator
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        plan.accept(new Visitor(session, plannerContext.getTypeManager(), typeAnalyzer, types), null);
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final Session session;
        private final TypeCoercion typeCoercion;
        private final TypeAnalyzer typeAnalyzer;
        private final TypeProvider types;

        public Visitor(Session session, TypeManager typeManager, TypeAnalyzer typeAnalyzer, TypeProvider types) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)typeManager).getType(arg_0));
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.types = Objects.requireNonNull(types, "types is null");
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            AggregationNode.Step step = node.getStep();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                AggregationNode.Aggregation aggregation = entry.getValue();
                switch (step) {
                    case SINGLE: {
                        this.checkSignature(symbol, aggregation.getResolvedFunction().getSignature());
                        this.checkCall(symbol, aggregation.getResolvedFunction().getSignature(), aggregation.getArguments());
                        break;
                    }
                    case FINAL: {
                        this.checkSignature(symbol, aggregation.getResolvedFunction().getSignature());
                        break;
                    }
                }
            }
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            this.checkWindowFunctions(node.getWindowFunctions());
            return null;
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
                Type expectedType = this.types.get(entry.getKey());
                if (entry.getValue() instanceof SymbolReference) {
                    SymbolReference symbolReference = (SymbolReference)entry.getValue();
                    this.verifyTypeSignature(entry.getKey(), expectedType, this.types.get(Symbol.from((Expression)symbolReference)));
                    continue;
                }
                Type actualType = this.typeAnalyzer.getType(this.session, this.types, entry.getValue());
                this.verifyTypeSignature(entry.getKey(), expectedType, actualType);
            }
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            ListMultimap<Symbol, Symbol> symbolMapping = node.getSymbolMapping();
            for (Symbol keySymbol : symbolMapping.keySet()) {
                List valueSymbols = symbolMapping.get((Object)keySymbol);
                Type expectedType = this.types.get(keySymbol);
                for (Symbol valueSymbol : valueSymbols) {
                    this.verifyTypeSignature(keySymbol, expectedType, this.types.get(valueSymbol));
                }
            }
            return null;
        }

        private void checkWindowFunctions(Map<Symbol, WindowNode.Function> functions) {
            functions.forEach((symbol, function) -> {
                this.checkSignature((Symbol)symbol, function.getResolvedFunction().getSignature());
                this.checkCall((Symbol)symbol, function.getResolvedFunction().getSignature(), function.getArguments());
            });
        }

        private void checkSignature(Symbol symbol, BoundSignature signature) {
            Type expectedType = this.types.get(symbol);
            Type actualType = signature.getReturnType();
            this.verifyTypeSignature(symbol, expectedType, actualType);
        }

        private void checkCall(Symbol symbol, BoundSignature signature, List<Expression> arguments) {
            Type expectedType = this.types.get(symbol);
            Type actualType = signature.getReturnType();
            this.verifyTypeSignature(symbol, expectedType, actualType);
            Preconditions.checkArgument((signature.getArgumentTypes().size() == arguments.size() ? 1 : 0) != 0, (String)"expected %s arguments, but found %s arguments", (int)signature.getArgumentTypes().size(), (int)arguments.size());
            for (int i = 0; i < arguments.size(); ++i) {
                Type expectedTypeSignature = (Type)signature.getArgumentTypes().get(i);
                if (expectedTypeSignature instanceof FunctionType) continue;
                Type actualTypeSignature = this.typeAnalyzer.getType(this.session, this.types, arguments.get(i));
                this.verifyTypeSignature(symbol, expectedTypeSignature, actualTypeSignature);
            }
        }

        private void verifyTypeSignature(Symbol symbol, Type expected, Type actual) {
            if (!(actual instanceof UnknownType) && !this.typeCoercion.isTypeOnlyCoercion(actual, expected)) {
                Preconditions.checkArgument((boolean)expected.equals(actual), (String)"type of symbol '%s' is expected to be %s, but the actual type is %s", (Object)symbol, (Object)expected, (Object)actual);
            }
        }
    }
}

