/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ValidateScaledWritersUsage
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        planNode.accept(new Visitor(session, plannerContext), null);
    }

    private static class Visitor
    extends PlanVisitor<List<PartitioningHandle>, Void> {
        private final Session session;
        private final PlannerContext plannerContext;

        private Visitor(Session session, PlannerContext plannerContext) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        }

        @Override
        protected List<PartitioningHandle> visitPlan(PlanNode node, Void context) {
            return this.collectPartitioningHandles(node.getSources());
        }

        @Override
        public List<PartitioningHandle> visitTableWriter(TableWriterNode node, Void context) {
            List<PartitioningHandle> children = this.collectPartitioningHandles(node.getSources());
            boolean anyScaledWriterDistribution = children.stream().anyMatch(partitioningHandle -> partitioningHandle == SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION);
            TableWriterNode.WriterTarget target = node.getTarget();
            Preconditions.checkState((!anyScaledWriterDistribution || target.supportsReportingWrittenBytes(this.plannerContext.getMetadata(), this.session) ? 1 : 0) != 0, (String)"The partitioning scheme is set to SCALED_WRITER_DISTRIBUTION but writer target %s does support for it", (Object)target);
            return children;
        }

        @Override
        public List<PartitioningHandle> visitExchange(ExchangeNode node, Void context) {
            return ImmutableList.builder().add((Object)node.getPartitioningScheme().getPartitioning().getHandle()).addAll(this.collectPartitioningHandles(node.getSources())).build();
        }

        private List<PartitioningHandle> collectPartitioningHandles(List<PlanNode> nodes) {
            return nodes.stream().map(node -> node.accept(this, null)).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }
}

