/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.trino.array.LongBigArray;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.LongBinaryOperator;
import org.openjdk.jol.info.ClassLayout;

public class LongLong2LongOpenCustomBigHashMap
implements Hash {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(LongLong2LongOpenCustomBigHashMap.class).instanceSize());
    private static final boolean ASSERTS = false;
    protected LongBigArray key1;
    protected LongBigArray key2;
    protected LongBigArray value;
    protected long mask;
    protected boolean containsNullKey;
    protected final HashStrategy strategy;
    protected long n;
    protected long maxFill;
    protected final long minN;
    protected long size;
    protected final float f;
    protected long defRetValue;
    protected final long nullKey1;
    protected final long nullKey2;

    public LongLong2LongOpenCustomBigHashMap(long expected, float f, HashStrategy strategy, long nullKey1, long nullKey2) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0L) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.bigArraySize((long)expected, (float)f);
        this.mask = this.n - 1L;
        this.maxFill = HashCommon.maxFill((long)this.n, (float)f);
        this.nullKey1 = nullKey1;
        this.nullKey2 = nullKey2;
        this.key1 = new LongBigArray(nullKey1);
        this.key1.ensureCapacity(this.n + 1L);
        this.key2 = new LongBigArray(nullKey2);
        this.key2.ensureCapacity(this.n + 1L);
        this.value = new LongBigArray();
        this.value.ensureCapacity(this.n + 1L);
    }

    public LongLong2LongOpenCustomBigHashMap(long expected, HashStrategy strategy, long nullKey1, long nullKey2) {
        this(expected, 0.75f, strategy, nullKey1, nullKey2);
    }

    public LongLong2LongOpenCustomBigHashMap(long expected, float f, HashStrategy strategy) {
        this(expected, f, strategy, 0L, 0L);
    }

    public LongLong2LongOpenCustomBigHashMap(long expected, HashStrategy strategy) {
        this(expected, 0.75f, strategy);
    }

    public LongLong2LongOpenCustomBigHashMap(HashStrategy strategy, long nullKey1, long nullKey2) {
        this(1024L, strategy, nullKey1, nullKey2);
    }

    public LongLong2LongOpenCustomBigHashMap(HashStrategy strategy) {
        this(1024L, 0.75f, strategy);
    }

    public void defaultReturnValue(long rv) {
        this.defRetValue = rv;
    }

    public long defaultReturnValue() {
        return this.defRetValue;
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + this.key1.sizeOf() + this.key2.sizeOf() + this.value.sizeOf();
    }

    public HashStrategy strategy() {
        return this.strategy;
    }

    private long realSize() {
        return this.containsNullKey ? this.size - 1L : this.size;
    }

    private long removeEntry(long pos) {
        long oldValue = this.value.get(pos);
        --this.size;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4L && this.n > 1024L) {
            this.rehash(this.n / 2L);
        }
        return oldValue;
    }

    private long removeNullEntry() {
        this.containsNullKey = false;
        long oldValue = this.value.get(this.n);
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4L && this.n > 1024L) {
            this.rehash(this.n / 2L);
        }
        return oldValue;
    }

    private long find(long k1, long k2) {
        if (this.strategy.equals(k1, k2, this.nullKey1, this.nullKey2)) {
            return this.containsNullKey ? this.n : -(this.n + 1L);
        }
        LongBigArray key1 = this.key1;
        LongBigArray key2 = this.key2;
        long pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
        long curr1 = key1.get(pos);
        long curr2 = key2.get(pos);
        if (curr1 == this.nullKey1 && curr2 == this.nullKey2) {
            return -(pos + 1L);
        }
        if (this.strategy.equals(k1, k2, curr1, curr2)) {
            return pos;
        }
        do {
            pos = pos + 1L & this.mask;
            curr1 = key1.get(pos);
            curr2 = key2.get(pos);
            if (curr1 != this.nullKey1 || curr2 != this.nullKey2) continue;
            return -(pos + 1L);
        } while (!this.strategy.equals(k1, k2, curr1, curr2));
        return pos;
    }

    private void insert(long pos, long k1, long k2, long v) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        this.key1.set(pos, k1);
        this.key2.set(pos, k2);
        this.value.set(pos, v);
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.bigArraySize((long)(this.size + 1L), (float)this.f));
        }
    }

    public long put(long k1, long k2, long v) {
        long pos = this.find(k1, k2);
        if (pos < 0L) {
            this.insert(-pos - 1L, k1, k2, v);
            return this.defRetValue;
        }
        long oldValue = this.value.get(pos);
        this.value.set(pos, v);
        return oldValue;
    }

    private long addToValue(long pos, long incr) {
        long oldValue = this.value.get(pos);
        this.value.set(pos, oldValue + incr);
        return oldValue;
    }

    public long addTo(long k1, long k2, long incr) {
        long pos;
        if (this.strategy.equals(k1, k2, this.nullKey1, this.nullKey2)) {
            if (this.containsNullKey) {
                return this.addToValue(this.n, incr);
            }
            pos = this.n;
            this.containsNullKey = true;
        } else {
            LongBigArray key1 = this.key1;
            LongBigArray key2 = this.key2;
            pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
            long curr1 = key1.get(pos);
            long curr2 = key2.get(pos);
            if (curr1 != this.nullKey1 || curr2 != this.nullKey2) {
                if (this.strategy.equals(curr1, curr2, k1, k2)) {
                    return this.addToValue(pos, incr);
                }
                pos = pos + 1L & this.mask;
                curr1 = key1.get(pos);
                curr2 = key2.get(pos);
                while (curr1 != this.nullKey1 || curr2 != this.nullKey2) {
                    if (this.strategy.equals(curr1, curr2, k1, k2)) {
                        return this.addToValue(pos, incr);
                    }
                    pos = pos + 1L & this.mask;
                    curr1 = key1.get(pos);
                    curr2 = key2.get(pos);
                }
            }
        }
        this.key1.set(pos, k1);
        this.key2.set(pos, k2);
        this.value.set(pos, this.defRetValue + incr);
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.bigArraySize((long)(this.size + 1L), (float)this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(long pos) {
        LongBigArray key1 = this.key1;
        LongBigArray key2 = this.key2;
        while (true) {
            long curr2;
            long curr1;
            long last = pos;
            pos = pos + 1L & this.mask;
            while (true) {
                curr1 = key1.get(pos);
                curr2 = key2.get(pos);
                if (curr1 == this.nullKey1 && curr2 == this.nullKey2) {
                    key1.set(last, this.nullKey1);
                    key2.set(last, this.nullKey2);
                    return;
                }
                long slot = HashCommon.mix((long)this.strategy.hashCode(curr1, curr2)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1L & this.mask;
            }
            key1.set(last, curr1);
            key2.set(last, curr2);
            this.value.set(last, this.value.get(pos));
        }
    }

    public long remove(long k1, long k2) {
        if (this.strategy.equals(k1, k2, this.nullKey1, this.nullKey2)) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        LongBigArray key1 = this.key1;
        LongBigArray key2 = this.key2;
        long pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
        long curr1 = key1.get(pos);
        long curr2 = key2.get(pos);
        if (curr1 == this.nullKey1 && curr2 == this.nullKey2) {
            return this.defRetValue;
        }
        if (this.strategy.equals(k1, k2, curr1, curr2)) {
            return this.removeEntry(pos);
        }
        do {
            pos = pos + 1L & this.mask;
            curr1 = key1.get(pos);
            curr2 = key2.get(pos);
            if (curr1 != this.nullKey1 || curr2 != this.nullKey2) continue;
            return this.defRetValue;
        } while (!this.strategy.equals(k1, k2, curr1, curr2));
        return this.removeEntry(pos);
    }

    public long get(long k1, long k2) {
        if (this.strategy.equals(k1, k2, this.nullKey1, this.nullKey2)) {
            return this.containsNullKey ? this.value.get(this.n) : this.defRetValue;
        }
        LongBigArray key1 = this.key1;
        LongBigArray key2 = this.key2;
        long pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
        long curr1 = key1.get(pos);
        long curr2 = key2.get(pos);
        if (curr1 == this.nullKey1 && curr2 == this.nullKey2) {
            return this.defRetValue;
        }
        if (this.strategy.equals(k1, k2, curr1, curr2)) {
            return this.value.get(pos);
        }
        do {
            pos = pos + 1L & this.mask;
            curr1 = key1.get(pos);
            curr2 = key2.get(pos);
            if (curr1 != this.nullKey1 || curr2 != this.nullKey2) continue;
            return this.defRetValue;
        } while (!this.strategy.equals(k1, k2, curr1, curr2));
        return this.value.get(pos);
    }

    public boolean containsKey(long k1, long k2) {
        if (this.strategy.equals(k1, k2, this.nullKey1, this.nullKey2)) {
            return this.containsNullKey;
        }
        LongBigArray key1 = this.key1;
        LongBigArray key2 = this.key2;
        long pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
        long curr1 = key1.get(pos);
        long curr2 = key2.get(pos);
        if (curr1 == this.nullKey1 && curr2 == this.nullKey2) {
            return false;
        }
        if (this.strategy.equals(k1, k2, curr1, curr2)) {
            return true;
        }
        do {
            pos = pos + 1L & this.mask;
            curr1 = key1.get(pos);
            curr2 = key2.get(pos);
            if (curr1 != this.nullKey1 || curr2 != this.nullKey2) continue;
            return false;
        } while (!this.strategy.equals(k1, k2, curr1, curr2));
        return true;
    }

    public boolean containsValue(long v) {
        LongBigArray value = this.value;
        LongBigArray key1 = this.key1;
        LongBigArray key2 = this.key2;
        if (this.containsNullKey && value.get(this.n) == v) {
            return true;
        }
        long i = this.n;
        while (i-- != 0L) {
            if (key1.get(i) == this.nullKey1 && key2.get(i) == this.nullKey2 || value.get(i) != v) continue;
            return true;
        }
        return false;
    }

    public long getOrDefault(long k1, long k2, long defaultValue) {
        if (this.strategy.equals(k1, k2, this.nullKey1, this.nullKey2)) {
            return this.containsNullKey ? this.value.get(this.n) : defaultValue;
        }
        LongBigArray key1 = this.key1;
        LongBigArray key2 = this.key2;
        long pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
        long curr1 = key1.get(pos);
        long curr2 = key2.get(pos);
        if (curr1 == this.nullKey1 && curr2 == this.nullKey2) {
            return defaultValue;
        }
        if (this.strategy.equals(k1, k2, curr1, curr2)) {
            return this.value.get(pos);
        }
        do {
            pos = pos + 1L & this.mask;
            curr1 = key1.get(pos);
            curr2 = key2.get(pos);
            if (curr1 != this.nullKey1 || curr2 != this.nullKey2) continue;
            return defaultValue;
        } while (!this.strategy.equals(k1, k2, curr1, curr2));
        return this.value.get(pos);
    }

    public long putIfAbsent(long k1, long k2, long v) {
        long pos = this.find(k1, k2);
        if (pos >= 0L) {
            return this.value.get(pos);
        }
        this.insert(-pos - 1L, k1, k2, v);
        return this.defRetValue;
    }

    public boolean remove(long k1, long k2, long v) {
        if (this.strategy.equals(k1, k2, this.nullKey1, this.nullKey2)) {
            if (this.containsNullKey && v == this.value.get(this.n)) {
                this.removeNullEntry();
                return true;
            }
            return false;
        }
        LongBigArray key1 = this.key1;
        LongBigArray key2 = this.key2;
        long pos = HashCommon.mix((long)this.strategy.hashCode(k1, k2)) & this.mask;
        long curr1 = key1.get(pos);
        long curr2 = key2.get(pos);
        if (curr1 == this.nullKey1 && curr2 == this.nullKey2) {
            return false;
        }
        if (this.strategy.equals(k1, k2, curr1, curr2) && v == this.value.get(pos)) {
            this.removeEntry(pos);
            return true;
        }
        do {
            pos = pos + 1L & this.mask;
            curr1 = key1.get(pos);
            curr2 = key2.get(pos);
            if (curr1 != this.nullKey1 || curr2 != this.nullKey2) continue;
            return false;
        } while (!this.strategy.equals(k1, k2, curr1, curr2) || v != this.value.get(pos));
        this.removeEntry(pos);
        return true;
    }

    public boolean replace(long k1, long k2, long oldValue, long v) {
        long pos = this.find(k1, k2);
        if (pos < 0L || oldValue != this.value.get(pos)) {
            return false;
        }
        this.value.set(pos, v);
        return true;
    }

    public long replace(long k1, long k2, long v) {
        long pos = this.find(k1, k2);
        if (pos < 0L) {
            return this.defRetValue;
        }
        long oldValue = this.value.get(pos);
        this.value.set(pos, v);
        return oldValue;
    }

    public long computeIfAbsent(long k1, long k2, LongBinaryOperator mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        long pos = this.find(k1, k2);
        if (pos >= 0L) {
            return this.value.get(pos);
        }
        long newValue = mappingFunction.applyAsLong(k1, k2);
        this.insert(-pos - 1L, k1, k2, newValue);
        return newValue;
    }

    public long merge(long k1, long k2, long v, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        long pos = this.find(k1, k2);
        if (pos < 0L) {
            this.insert(-pos - 1L, k1, k2, v);
            return v;
        }
        Long newValue = remappingFunction.apply((Long)this.value.get(pos), (Long)v);
        if (newValue == null) {
            if (this.strategy.equals(k1, k2, this.nullKey1, this.nullKey2)) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos);
            }
            return this.defRetValue;
        }
        this.value.set(pos, newValue.longValue());
        return newValue;
    }

    public void clear() {
        if (this.size == 0L) {
            return;
        }
        this.size = 0L;
        this.containsNullKey = false;
        this.key1.fill(this.nullKey1);
        this.key2.fill(this.nullKey2);
    }

    public long size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public boolean trim() {
        return this.trim(this.size);
    }

    public boolean trim(long n) {
        long l = HashCommon.bigArraySize((long)n, (float)this.f);
        if (l >= this.n || this.size > HashCommon.maxFill((long)l, (float)this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(long newN) {
        LongBigArray key1 = this.key1;
        LongBigArray key2 = this.key2;
        LongBigArray value = this.value;
        long mask = newN - 1L;
        LongBigArray newKey1 = new LongBigArray(this.nullKey1);
        newKey1.ensureCapacity(newN + 1L);
        LongBigArray newKey2 = new LongBigArray(this.nullKey2);
        newKey2.ensureCapacity(newN + 1L);
        LongBigArray newValue = new LongBigArray();
        newValue.ensureCapacity(newN + 1L);
        long i = this.n;
        long j = this.realSize();
        while (j-- != 0L) {
            --i;
            while (key1.get(i) == this.nullKey1 && key2.get(i) == this.nullKey2) {
                --i;
            }
            long pos = HashCommon.mix((long)this.strategy.hashCode(key1.get(i), key2.get(i))) & mask;
            if (newKey1.get(pos) != this.nullKey1 || newKey2.get(pos) != this.nullKey2) {
                pos = pos + 1L & mask;
                while (newKey1.get(pos) != this.nullKey1 || newKey2.get(pos) != this.nullKey2) {
                    pos = pos + 1L & mask;
                }
            }
            newKey1.set(pos, key1.get(i));
            newKey2.set(pos, key2.get(i));
            newValue.set(pos, value.get(i));
        }
        newValue.set(newN, value.get(this.n));
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill((long)this.n, (float)this.f);
        this.key1 = newKey1;
        this.key2 = newKey2;
        this.value = newValue;
    }

    private void checkTable() {
    }

    public static interface HashStrategy {
        public long hashCode(long var1, long var3);

        public boolean equals(long var1, long var3, long var5, long var7);
    }
}

