/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.qubole.rubix.core.CachingFileSystemStatsProvider;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.utils.DataSizeUnits;
import org.apache.hadoop.conf.Configuration;
import org.weakref.shaded.jmx.Managed;

public class BasicCachingFileSystemStats {
    protected final CachingFileSystemStatsProvider statsProvider;
    protected final BookKeeperFactory bookKeeperFactory;
    protected final Configuration conf;

    public BasicCachingFileSystemStats(CachingFileSystemStatsProvider statsProvider, BookKeeperFactory bookKeeperFactory, Configuration conf) {
        this.statsProvider = statsProvider;
        this.bookKeeperFactory = bookKeeperFactory;
        this.conf = conf;
    }

    @Managed(description="Gets the total size in MB that was read from Source during the reads")
    public long getMB_read_from_source() {
        return DataSizeUnits.BYTES.toMB(this.statsProvider.getStats().getDirectRRCDataRead() + this.statsProvider.getStats().getRemoteRRCDataRead() + this.statsProvider.getStats().getDownloadedFromSourceForNonLocalRequests(this.bookKeeperFactory, this.conf));
    }

    @Managed(description="Gets the total size in MB that was read from cache")
    public long getMB_read_from_cache() {
        return DataSizeUnits.BYTES.toMB(this.statsProvider.getStats().getCachedRRCDataRead() + this.statsProvider.getStats().getNonLocalRRCDataRead());
    }

    @Managed(description="Return cache hit ratio")
    public double getCache_hit() {
        long readFromCache = this.getMB_read_from_cache();
        return (double)readFromCache / (double)(readFromCache + this.getMB_read_from_source());
    }
}

