/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.qubole.rubix.core.BasicCachingFileSystemStats;
import com.qubole.rubix.core.CachingFileSystemStatsProvider;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.utils.DataSizeUnits;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.weakref.shaded.jmx.Managed;

public class DetailedCachingFileSystemStats
extends BasicCachingFileSystemStats {
    public DetailedCachingFileSystemStats(CachingFileSystemStatsProvider statsProvider, BookKeeperFactory bookKeeperFactory, Configuration conf) {
        super(statsProvider, bookKeeperFactory, conf);
    }

    @Managed(description="Get the total MB downloaded for local requests")
    public long getRemote_rrc_data_read() {
        return DataSizeUnits.BYTES.toMB(this.statsProvider.getStats().getRemoteRRCDataRead());
    }

    @Managed(description="Gets the extra  MB read from remote files due to block alignment for local requests")
    public long getRemote_rrc_extra_data_read() {
        return DataSizeUnits.BYTES.toMB(this.statsProvider.getStats().getRemoteRRCExtraDataRead());
    }

    @Managed(description="Gets the time in seconds spent in copying data into cache buffers. This is aggregated across all threads hence not the user visible penalty")
    public long getRemote_rrc_warmup_penalty() {
        return TimeUnit.NANOSECONDS.toSeconds(this.statsProvider.getStats().getRemoteRRCWarmupTime());
    }

    @Managed(description="Gets the total number of local requests on cold cache")
    public long getRemote_rrc_requests() {
        return this.statsProvider.getStats().getRemoteRRCRequests();
    }

    @Managed(description="Gets the MB read from local cache")
    public long getCached_rrc_data_read() {
        return DataSizeUnits.BYTES.toMB(this.statsProvider.getStats().getCachedRRCDataRead());
    }

    @Managed(description="Gets the total number of request served from local cache")
    public long getCached_rrc_requests() {
        return this.statsProvider.getStats().getCachedRRCRequests();
    }

    @Managed(description="Gets the total size in MB that was read from Source but not cached")
    public long getDirect_rrc_data_read() {
        return DataSizeUnits.BYTES.toMB(this.statsProvider.getStats().getDirectRRCDataRead());
    }

    @Managed(description="Gets the number of direct requests")
    public long getDirect_rrc_requests() {
        return this.statsProvider.getStats().getDirectRRCRequests();
    }

    @Managed(description="Gets the total size in MB that was read from non-local caches")
    public long getNonlocal_rrc_data_read() {
        return DataSizeUnits.BYTES.toMB(this.statsProvider.getStats().getNonLocalRRCDataRead());
    }

    @Managed(description="Gets the total number of non-local reads")
    public long getNonlocal_rrc_requests() {
        return this.statsProvider.getStats().getNonLocalRRCRequests();
    }

    @Managed(description="Gets the total size in MB that was downloaded for non-local requests")
    public long getBKS_data_downloaded_in_read_through() {
        return DataSizeUnits.BYTES.toMB(this.statsProvider.getStats().getDownloadedFromSourceForNonLocalRequests(this.bookKeeperFactory, this.conf));
    }

    @Managed(description="Gets the extra  MB read from remote files due to block alignment for non-local requests")
    public long getBKS_extra_data_read_in_read_through() {
        return DataSizeUnits.BYTES.toMB(this.statsProvider.getStats().getExtraReadFromSourceForNonLocalRequests(this.bookKeeperFactory, this.conf));
    }

    @Managed(description="Aggregated warmup penalty to non-local reads due to warmup")
    public long getBKS_warmup_penalty_in_read_through() {
        return TimeUnit.NANOSECONDS.toSeconds(this.statsProvider.getStats().getWarmupTimeForNonLocalRequests(this.bookKeeperFactory, this.conf));
    }

    @Managed(description="Gets the total size in MB that was downloaded by parallel warmup")
    public long getBKS_data_downloaded_in_parallel_warmup() {
        return DataSizeUnits.BYTES.toMB(this.statsProvider.getStats().getDownloadedFromSourceParallel(this.bookKeeperFactory, this.conf));
    }

    @Managed(description="Total walltime of downloads in parallel warmup")
    public long getBKS_time_for_parallel_downloads() {
        return TimeUnit.NANOSECONDS.toSeconds(this.statsProvider.getStats().getTotalTimeForParallelDownload(this.bookKeeperFactory, this.conf));
    }

    @Managed(description="Gets the total number corrupted files that have been invalidated")
    public int getcorrupted_file_count() {
        return this.statsProvider.getStats().getCorruptedFileCount();
    }

    @Managed(description="Total data read from source by the system")
    public long getTotal_system_source_MB_read() {
        return this.getMB_read_from_source() + this.statsProvider.getStats().getDownloadedFromSourceParallel(this.bookKeeperFactory, this.conf);
    }
}

