/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.DataType;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IntervalDayTimeDataType
extends DataType {
    private final Field from;
    private final Field to;

    public IntervalDayTimeDataType(NodeLocation location, Field from, Field to) {
        this(Optional.of(location), from, to);
    }

    public IntervalDayTimeDataType(Optional<NodeLocation> location, Field from, Field to) {
        super(location);
        this.from = Objects.requireNonNull(from, "from is null");
        this.to = Objects.requireNonNull(to, "to is null");
    }

    public Field getFrom() {
        return this.from;
    }

    public Field getTo() {
        return this.to;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIntervalDataType(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalDayTimeDataType that = (IntervalDayTimeDataType)o;
        return this.from == that.from && this.to == that.to;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.from, this.to});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!IntervalDayTimeDataType.sameClass(this, other)) {
            return false;
        }
        IntervalDayTimeDataType otherType = (IntervalDayTimeDataType)other;
        return this.from.equals((Object)otherType.from) && this.to == otherType.to;
    }

    public static enum Field {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }
}

