/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.QualifiedName;
import coral.shading.io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class RenameView
extends Statement {
    private final QualifiedName source;
    private final QualifiedName target;

    public RenameView(QualifiedName source, QualifiedName target) {
        this(Optional.empty(), source, target);
    }

    public RenameView(NodeLocation location, QualifiedName source, QualifiedName target) {
        this(Optional.of(location), source, target);
    }

    private RenameView(Optional<NodeLocation> location, QualifiedName source, QualifiedName target) {
        super(location);
        this.source = Objects.requireNonNull(source, "source name is null");
        this.target = Objects.requireNonNull(target, "target name is null");
    }

    public QualifiedName getSource() {
        return this.source;
    }

    public QualifiedName getTarget() {
        return this.target;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRenameView(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.target);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RenameView o = (RenameView)obj;
        return Objects.equals(this.source, o.source) && Objects.equals(this.target, o.target);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("source", this.source).add("target", this.target).toString();
    }
}

