/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups.db;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.resourcegroups.db.DaoProvider;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfig;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfigurationManager;
import io.trino.plugin.resourcegroups.db.ResourceGroupsDao;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManager;
import org.jdbi.v3.core.Jdbi;
import org.weakref.jmx.guice.ExportBinder;

public class DbResourceGroupsModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(DbResourceGroupConfig.class);
        binder.bind(ResourceGroupsDao.class).toProvider(DaoProvider.class).in(Scopes.SINGLETON);
        binder.bind(DbResourceGroupConfigurationManager.class).in(Scopes.SINGLETON);
        binder.bind(ResourceGroupConfigurationManager.class).to(DbResourceGroupConfigurationManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(DbResourceGroupConfigurationManager.class).withGeneratedName();
    }

    @Provides
    @Singleton
    public static Jdbi create(DbResourceGroupConfig config) {
        return Jdbi.create((String)config.getConfigDbUrl(), (String)config.getConfigDbUser(), (String)config.getConfigDbPassword());
    }
}

