/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups.db;

import io.airlift.log.Logger;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfig;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.output.MigrateResult;

public class FlywayMigration {
    private static final Logger log = Logger.get(FlywayMigration.class);

    private FlywayMigration() {
    }

    private static String getLocation(String configDbUrl) {
        if (configDbUrl.startsWith("jdbc:postgresql")) {
            return "/db/migration/postgresql";
        }
        if (configDbUrl.startsWith("jdbc:oracle")) {
            return "/db/migration/oracle";
        }
        if (configDbUrl.startsWith("jdbc:mysql")) {
            return "/db/migration/mysql";
        }
        throw new IllegalArgumentException(String.format("Invalid JDBC URL: %s. Only PostgreSQL, MySQL, and Oracle are supported.", configDbUrl));
    }

    public static void migrate(DbResourceGroupConfig config) {
        log.info("Performing migrations...");
        Flyway flyway = Flyway.configure().dataSource(config.getConfigDbUrl(), config.getConfigDbUser(), config.getConfigDbPassword()).locations(new String[]{FlywayMigration.getLocation(config.getConfigDbUrl())}).baselineOnMigrate(true).baselineVersion("0").load();
        MigrateResult migrations = flyway.migrate();
        log.info("Performed %s migrations", new Object[]{migrations.migrationsExecuted});
    }
}

