/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.singlestore;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalModule;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.ptf.Query;
import io.trino.plugin.singlestore.SingleStoreClient;
import io.trino.plugin.singlestore.SingleStoreConfig;
import io.trino.plugin.singlestore.SingleStoreJdbcConfig;
import io.trino.spi.ptf.ConnectorTableFunction;
import java.sql.Driver;
import java.util.Properties;

public class SingleStoreClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(SingleStoreClient.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(SingleStoreJdbcConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(SingleStoreConfig.class);
        binder.install((Module)new DecimalModule());
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public static ConnectionFactory createConnectionFactory(SingleStoreJdbcConfig config, CredentialProvider credentialProvider, SingleStoreConfig singleStoreConfig) {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("tinyInt1isBit", "false");
        connectionProperties.setProperty("autoReconnect", String.valueOf(singleStoreConfig.isAutoReconnect()));
        connectionProperties.setProperty("connectTimeout", String.valueOf(singleStoreConfig.getConnectionTimeout().toMillis()));
        return new DriverConnectionFactory((Driver)new com.singlestore.jdbc.Driver(), config.getConnectionUrl(), connectionProperties, credentialProvider);
    }
}

