/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.singlestore;

import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.log.Logger;
import io.trino.plugin.jdbc.ExtraCredentialsBasedIdentityCacheMappingModule;
import io.trino.plugin.jdbc.JdbcConnectorFactory;
import io.trino.plugin.jdbc.credential.CredentialProviderModule;
import io.trino.plugin.singlestore.SingleStoreClientModule;
import io.trino.spi.Plugin;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;

public class SingleStorePlugin
implements Plugin {
    private static final Logger log = Logger.get(SingleStorePlugin.class);

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)((Object)new SingleStoreConnectorFactory("singlestore")), (Object)((Object)new LegacyMemSqlConnectorFactory()));
    }

    private static class SingleStoreConnectorFactory
    extends JdbcConnectorFactory {
        public SingleStoreConnectorFactory(String name) {
            super(name, ConfigurationAwareModule.combine((Module[])new Module[]{new CredentialProviderModule(), new ExtraCredentialsBasedIdentityCacheMappingModule(), new SingleStoreClientModule()}));
        }
    }

    private static class LegacyMemSqlConnectorFactory
    extends SingleStoreConnectorFactory {
        public LegacyMemSqlConnectorFactory() {
            super("memsql");
        }

        public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
            log.warn("Connector name 'memsql' is deprecated. Use 'singlestore' instead.");
            return super.create(catalogName, config, context);
        }
    }
}

