/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata.statistics;

import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class StripeStatistics {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(StripeStatistics.class).instanceSize());
    private final ColumnMetadata<ColumnStatistics> columnStatistics;
    private final long retainedSizeInBytes;

    public StripeStatistics(ColumnMetadata<ColumnStatistics> columnStatistics) {
        this.columnStatistics = Objects.requireNonNull(columnStatistics, "columnStatistics is null");
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + columnStatistics.stream().mapToLong(ColumnStatistics::getRetainedSizeInBytes).sum();
    }

    public ColumnMetadata<ColumnStatistics> getColumnStatistics() {
        return this.columnStatistics;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StripeStatistics that = (StripeStatistics)o;
        return Objects.equals(this.columnStatistics, that.columnStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.columnStatistics);
    }
}

