/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.Stream;
import io.trino.orc.reader.ColumnReader;
import io.trino.orc.reader.ReaderUtils;
import io.trino.orc.stream.BooleanInputStream;
import io.trino.orc.stream.ByteInputStream;
import io.trino.orc.stream.InputStreamSource;
import io.trino.orc.stream.InputStreamSources;
import io.trino.orc.stream.MissingInputStreamSource;
import io.trino.spi.block.Block;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class ByteColumnReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(ByteColumnReader.class).instanceSize());
    private final Type type;
    private final OrcColumn column;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<ByteInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(ByteInputStream.class);
    @Nullable
    private ByteInputStream dataStream;
    private boolean rowGroupOpen;
    private byte[] nonNullValueTemp = new byte[0];
    private final LocalMemoryContext memoryContext;

    public ByteColumnReader(Type type, OrcColumn column, LocalMemoryContext memoryContext) throws OrcCorruptionException {
        this.type = Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(column, type, t -> t == TinyintType.TINYINT || t == IntegerType.INTEGER);
        this.column = Objects.requireNonNull(column, "column is null");
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is missing");
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.dataStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            block = RunLengthEncodedBlock.create((Type)this.type, null, (int)this.nextBatchSize);
        } else {
            boolean[] isNull;
            int nullCount;
            block = this.presentStream == null ? this.readNonNullBlock() : ((nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull = new boolean[this.nextBatchSize])) == 0 ? this.readNonNullBlock() : (nullCount != this.nextBatchSize ? this.readNullBlock(isNull, this.nextBatchSize - nullCount) : RunLengthEncodedBlock.create((Type)this.type, null, (int)this.nextBatchSize)));
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private Block readNonNullBlock() throws IOException {
        Verify.verifyNotNull((Object)this.dataStream);
        byte[] values = new byte[this.nextBatchSize];
        this.dataStream.next(values, this.nextBatchSize);
        if (this.type == TinyintType.TINYINT) {
            return new ByteArrayBlock(this.nextBatchSize, Optional.empty(), values);
        }
        if (this.type == IntegerType.INTEGER) {
            return new IntArrayBlock(this.nextBatchSize, Optional.empty(), ByteColumnReader.convertToIntArray(values));
        }
        throw new VerifyError("Unsupported type " + this.type);
    }

    private Block readNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verifyNotNull((Object)this.dataStream);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.nonNullValueTemp.length < minNonNullValueSize) {
            this.nonNullValueTemp = new byte[minNonNullValueSize];
            this.memoryContext.setBytes(SizeOf.sizeOf((byte[])this.nonNullValueTemp));
        }
        this.dataStream.next(this.nonNullValueTemp, nonNullCount);
        byte[] result = ReaderUtils.unpackByteNulls(this.nonNullValueTemp, isNull);
        if (this.type == TinyintType.TINYINT) {
            return new ByteArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
        }
        if (this.type == IntegerType.INTEGER) {
            return new IntArrayBlock(this.nextBatchSize, Optional.of(isNull), ByteColumnReader.convertToIntArray(result));
        }
        throw new VerifyError("Unsupported type " + this.type);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(ByteInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.DATA, ByteInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    private static int[] convertToIntArray(byte[] bytes) {
        int[] values = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            values[i] = bytes[i];
        }
        return values;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    @Override
    public void close() {
        this.memoryContext.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

