/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.optimizer.lineage.LineageCtx;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HookContext {
    private QueryPlan queryPlan;
    private final QueryState queryState;
    private HiveConf conf;
    private List<TaskRunner> completeTaskList;
    private Set<ReadEntity> inputs;
    private Set<WriteEntity> outputs;
    private LineageInfo linfo;
    private LineageCtx.Index depMap;
    private UserGroupInformation ugi;
    private HookType hookType;
    private String errorMessage;
    private Throwable exception;
    private final Map<String, ContentSummary> inputPathToContentSummary;
    private final String ipAddress;
    private final String hiveInstanceAddress;
    private final String userName;
    private final String operationId;
    private final String sessionId;
    private final String threadId;
    private final boolean isHiveServerQuery;
    private final PerfLogger perfLogger;
    private final QueryInfo queryInfo;

    public HookContext(QueryPlan queryPlan, QueryState queryState, Map<String, ContentSummary> inputPathToContentSummary, String userName, String ipAddress, String hiveInstanceAddress, String operationId, String sessionId, String threadId, boolean isHiveServerQuery, PerfLogger perfLogger, QueryInfo queryInfo) throws Exception {
        this.queryPlan = queryPlan;
        this.queryState = queryState;
        this.conf = queryState.getConf();
        this.inputPathToContentSummary = inputPathToContentSummary;
        this.completeTaskList = new ArrayList<TaskRunner>();
        this.inputs = queryPlan.getInputs();
        this.outputs = queryPlan.getOutputs();
        this.ugi = Utils.getUGI();
        this.linfo = queryState.getLineageState().getLineageInfo();
        this.depMap = queryState.getLineageState().getIndex();
        this.userName = userName;
        this.ipAddress = ipAddress;
        this.hiveInstanceAddress = hiveInstanceAddress;
        this.operationId = operationId;
        this.sessionId = sessionId;
        this.threadId = threadId;
        this.isHiveServerQuery = isHiveServerQuery;
        this.perfLogger = perfLogger;
        this.queryInfo = queryInfo;
    }

    public QueryPlan getQueryPlan() {
        return this.queryPlan;
    }

    public void setQueryPlan(QueryPlan queryPlan) {
        this.queryPlan = queryPlan;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public void setConf(HiveConf conf) {
        this.conf = conf;
    }

    public List<TaskRunner> getCompleteTaskList() {
        return this.completeTaskList;
    }

    public void setCompleteTaskList(List<TaskRunner> completeTaskList) {
        this.completeTaskList = completeTaskList;
    }

    public void addCompleteTask(TaskRunner completeTaskRunner) {
        this.completeTaskList.add(completeTaskRunner);
    }

    public Set<ReadEntity> getInputs() {
        return this.inputs;
    }

    public void setInputs(Set<ReadEntity> inputs) {
        this.inputs = inputs;
    }

    public Set<WriteEntity> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Set<WriteEntity> outputs) {
        this.outputs = outputs;
    }

    public LineageInfo getLinfo() {
        return this.linfo;
    }

    public void setLinfo(LineageInfo linfo) {
        this.linfo = linfo;
    }

    public LineageCtx.Index getIndex() {
        return this.depMap;
    }

    public void setIndex(LineageCtx.Index depMap) {
        this.depMap = depMap;
    }

    public UserGroupInformation getUgi() {
        return this.ugi;
    }

    public void setUgi(UserGroupInformation ugi) {
        this.ugi = ugi;
    }

    public Map<String, ContentSummary> getInputPathToContentSummary() {
        return this.inputPathToContentSummary;
    }

    public HookType getHookType() {
        return this.hookType;
    }

    public void setHookType(HookType hookType) {
        this.hookType = hookType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getHiveInstanceAddress() {
        return this.hiveInstanceAddress;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getOperationName() {
        return this.queryPlan.getOperationName();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public QueryState getQueryState() {
        return this.queryState;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public boolean isHiveServerQuery() {
        return this.isHiveServerQuery;
    }

    public PerfLogger getPerfLogger() {
        return this.perfLogger;
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public static enum HookType {
        PRE_EXEC_HOOK,
        POST_EXEC_HOOK,
        ON_FAILURE_HOOK;

    }
}

