/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BasicStatsWork;
import org.apache.hadoop.hive.ql.plan.IStatsGatherDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.mapred.InputFormat;

public class ProcessAnalyzeTable
implements NodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessAnalyzeTable.class.getName());
    private GenTezUtils utils = null;

    public ProcessAnalyzeTable(GenTezUtils utils) {
        this.utils = utils;
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        GenTezProcContext context = (GenTezProcContext)procContext;
        TableScanOperator tableScan = (TableScanOperator)nd;
        ParseContext parseContext = context.parseContext;
        Table table = ((TableScanDesc)tableScan.getConf()).getTableMetadata();
        Class<? extends InputFormat> inputFormat = table.getInputFormatClass();
        if (parseContext.getQueryProperties().isAnalyzeCommand()) {
            assert (tableScan.getChildOperators() == null || tableScan.getChildOperators().size() == 0);
            String alias = null;
            for (String a : parseContext.getTopOps().keySet()) {
                if (tableScan != parseContext.getTopOps().get(a)) continue;
                alias = a;
            }
            assert (alias != null);
            TezWork tezWork = (TezWork)context.currentTask.getWork();
            if (OrcInputFormat.class.isAssignableFrom(inputFormat) || MapredParquetInputFormat.class.isAssignableFrom(inputFormat)) {
                StatsWork statWork = new StatsWork(table, parseContext.getConf());
                statWork.setFooterScan();
                Set<Partition> confirmedParts = GenMapRedUtils.getConfirmedPartitionsForScan(tableScan);
                if (confirmedParts.size() > 0) {
                    List<String> partCols = GenMapRedUtils.getPartitionColumns(tableScan);
                    PrunedPartitionList partList = new PrunedPartitionList(table, confirmedParts, partCols, false);
                    statWork.addInputPartitions(partList.getPartitions());
                }
                Task<StatsWork> snjTask = TaskFactory.get(statWork);
                snjTask.setParentTasks(null);
                context.rootTasks.remove(context.currentTask);
                context.rootTasks.add(snjTask);
                return true;
            }
            BasicStatsWork basicStatsWork = new BasicStatsWork(table.getTableSpec());
            basicStatsWork.setIsExplicitAnalyze(true);
            basicStatsWork.setNoScanAnalyzeCommand(parseContext.getQueryProperties().isNoScanAnalyzeCommand());
            StatsWork columnStatsWork = new StatsWork(table, basicStatsWork, parseContext.getConf());
            columnStatsWork.collectStatsFromAggregator((IStatsGatherDesc)tableScan.getConf());
            columnStatsWork.setSourceTask(context.currentTask);
            Task<StatsWork> statsTask = TaskFactory.get(columnStatsWork);
            context.currentTask.addDependentTask(statsTask);
            if (parseContext.getQueryProperties().isNoScanAnalyzeCommand()) {
                statsTask.setParentTasks(null);
                context.rootTasks.remove(context.currentTask);
                context.rootTasks.add(statsTask);
            }
            Set<Partition> confirmedPartns = GenMapRedUtils.getConfirmedPartitionsForScan(tableScan);
            PrunedPartitionList partitions = null;
            if (confirmedPartns.size() > 0) {
                List<String> partCols = GenMapRedUtils.getPartitionColumns(tableScan);
                partitions = new PrunedPartitionList(table, confirmedPartns, partCols, false);
            }
            MapWork w = this.utils.createMapWork(context, tableScan, tezWork, partitions);
            w.setGatheringStats(true);
            return true;
        }
        return null;
    }
}

