/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="next_day", value="_FUNC_(start_date, day_of_week) - Returns the first date which is later than start_date and named as indicated.", extended="start_date is a string in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. day_of_week is day of the week (e.g. Mo, tue, FRIDAY).Example:\n  > SELECT _FUNC_('2015-01-14', 'TU') FROM src LIMIT 1;\n '2015-01-20'")
public class GenericUDFNextDay
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[2];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];
    private final Date date = new Date();
    private final Text output = new Text();
    private transient int dayOfWeekIntConst;
    private transient boolean isDayOfWeekConst;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 2);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        this.checkArgGroups(arguments, 0, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.checkArgGroups(arguments, 1, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.obtainDateConverter(arguments, 0, this.inputTypes, this.converters);
        this.obtainStringConverter(arguments, 1, this.inputTypes, this.converters);
        if (arguments[1] instanceof ConstantObjectInspector) {
            String dayOfWeek = this.getConstantStringValue(arguments, 1);
            this.isDayOfWeekConst = true;
            this.dayOfWeekIntConst = this.getIntDayOfWeek(dayOfWeek);
        }
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int dayOfWeekInt;
        if (this.isDayOfWeekConst) {
            dayOfWeekInt = this.dayOfWeekIntConst;
        } else {
            String dayOfWeek = this.getStringValue(arguments, 1, this.converters);
            dayOfWeekInt = this.getIntDayOfWeek(dayOfWeek);
        }
        if (dayOfWeekInt == -1) {
            return null;
        }
        Date d = this.getDateValue(arguments, 0, this.inputTypes, this.converters);
        if (d == null) {
            return null;
        }
        this.nextDay(d, dayOfWeekInt);
        this.output.set(this.date.toString());
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    @Override
    protected String getFuncName() {
        return "next_day";
    }

    protected Date nextDay(Date d, int dayOfWeek) {
        this.date.setTimeInDays(d.toEpochDay());
        int currDayOfWeek = this.date.getDayOfWeek();
        int daysToAdd = currDayOfWeek < dayOfWeek ? dayOfWeek - currDayOfWeek : 7 - currDayOfWeek + dayOfWeek;
        this.date.setTimeInDays(this.date.toEpochDay() + daysToAdd);
        return this.date;
    }

    protected int getIntDayOfWeek(String dayOfWeek) throws UDFArgumentException {
        if (dayOfWeek == null) {
            return -1;
        }
        if (DayOfWeek.MON.matches(dayOfWeek)) {
            return 2;
        }
        if (DayOfWeek.TUE.matches(dayOfWeek)) {
            return 3;
        }
        if (DayOfWeek.WED.matches(dayOfWeek)) {
            return 4;
        }
        if (DayOfWeek.THU.matches(dayOfWeek)) {
            return 5;
        }
        if (DayOfWeek.FRI.matches(dayOfWeek)) {
            return 6;
        }
        if (DayOfWeek.SAT.matches(dayOfWeek)) {
            return 7;
        }
        if (DayOfWeek.SUN.matches(dayOfWeek)) {
            return 1;
        }
        return -1;
    }

    public static enum DayOfWeek {
        MON("MO", "MON", "MONDAY"),
        TUE("TU", "TUE", "TUESDAY"),
        WED("WE", "WED", "WEDNESDAY"),
        THU("TH", "THU", "THURSDAY"),
        FRI("FR", "FRI", "FRIDAY"),
        SAT("SA", "SAT", "SATURDAY"),
        SUN("SU", "SUN", "SUNDAY");

        private final String name2;
        private final String name3;
        private final String fullName;

        private DayOfWeek(String name2, String name3, String fullName) {
            this.name2 = name2;
            this.name3 = name3;
            this.fullName = fullName;
        }

        public String getName2() {
            return this.name2;
        }

        public String getName3() {
            return this.name3;
        }

        public String getFullName() {
            return this.fullName;
        }

        public boolean matches(String dayOfWeek) {
            if (dayOfWeek.length() == 2) {
                return this.name2.equalsIgnoreCase(dayOfWeek);
            }
            if (dayOfWeek.length() == 3) {
                return this.name3.equalsIgnoreCase(dayOfWeek);
            }
            return this.fullName.equalsIgnoreCase(dayOfWeek);
        }
    }
}

