/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.fileio;

import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.fileio.ForwardingInputFile;
import io.trino.filesystem.fileio.ForwardingOutputFile;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;

public class ForwardingFileIo
implements FileIO {
    private final TrinoFileSystem fileSystem;

    public ForwardingFileIo(TrinoFileSystem fileSystem) {
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
    }

    public InputFile newInputFile(String path) {
        return new ForwardingInputFile(this.fileSystem.newInputFile(path));
    }

    public InputFile newInputFile(String path, long length) {
        return new ForwardingInputFile(this.fileSystem.newInputFile(path, length));
    }

    public OutputFile newOutputFile(String path) {
        return new ForwardingOutputFile(this.fileSystem, path);
    }

    public void deleteFile(String path) {
        try {
            this.fileSystem.deleteFile(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to delete file: " + path, e);
        }
    }
}

