/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.authentication;

import io.trino.hdfs.authentication.ForHdfs;
import io.trino.hdfs.authentication.GenericExceptionAction;
import io.trino.hdfs.authentication.HadoopAuthentication;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.UserGroupInformationUtils;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import javax.inject.Inject;

public class DirectHdfsAuthentication
implements HdfsAuthentication {
    private final HadoopAuthentication hadoopAuthentication;

    @Inject
    public DirectHdfsAuthentication(@ForHdfs HadoopAuthentication hadoopAuthentication) {
        this.hadoopAuthentication = Objects.requireNonNull(hadoopAuthentication);
    }

    @Override
    public <R, E extends Exception> R doAs(ConnectorIdentity identity, GenericExceptionAction<R, E> action) throws E {
        return UserGroupInformationUtils.executeActionInDoAs(this.hadoopAuthentication.getUserGroupInformation(), action);
    }
}

