/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LRUMap<K, V>
extends LinkedHashMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient Lock _readLock;
    protected final transient Lock _writeLock;
    protected final transient int _maxEntries;
    protected transient int _jdkSerializeMaxEntries;

    public LRUMap(int initialEntries, int maxEntries) {
        super(initialEntries, 0.8f, true);
        this._maxEntries = maxEntries;
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this._readLock = rwl.readLock();
        this._writeLock = rwl.writeLock();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this._maxEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        this._readLock.lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this._writeLock.lock();
        try {
            V v = super.put(key, value);
            return v;
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this._writeLock.lock();
        try {
            Object v = super.remove(key);
            return v;
        }
        finally {
            this._writeLock.unlock();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this._jdkSerializeMaxEntries = in.readInt();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._jdkSerializeMaxEntries);
    }

    protected Object readResolve() {
        return new LRUMap<K, V>(this._jdkSerializeMaxEntries, this._jdkSerializeMaxEntries);
    }
}

